/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.GroundStationData;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse;

public class ListGroundStationsPublisher
implements SdkPublisher<ListGroundStationsResponse> {
    private final GroundStationAsyncClient client;
    private final ListGroundStationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroundStationsPublisher(GroundStationAsyncClient client, ListGroundStationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroundStationsPublisher(GroundStationAsyncClient client, ListGroundStationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroundStationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroundStationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroundStationData> groundStationList() {
        Function<ListGroundStationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groundStationList() != null) {
                return response.groundStationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroundStationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroundStationsResponseFetcher
    implements AsyncPageFetcher<ListGroundStationsResponse> {
        private ListGroundStationsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroundStationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroundStationsResponse> nextPage(ListGroundStationsResponse previousPage) {
            if (previousPage == null) {
                return ListGroundStationsPublisher.this.client.listGroundStations(ListGroundStationsPublisher.this.firstRequest);
            }
            return ListGroundStationsPublisher.this.client.listGroundStations((ListGroundStationsRequest)((Object)ListGroundStationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

