/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse;
import software.amazon.awssdk.services.groundstation.model.MissionProfileListItem;

public class ListMissionProfilesIterable
implements SdkIterable<ListMissionProfilesResponse> {
    private final GroundStationClient client;
    private final ListMissionProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMissionProfilesIterable(GroundStationClient client, ListMissionProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMissionProfilesResponseFetcher();
    }

    public Iterator<ListMissionProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MissionProfileListItem> missionProfileList() {
        Function<ListMissionProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.missionProfileList() != null) {
                return response.missionProfileList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMissionProfilesResponseFetcher
    implements SyncPageFetcher<ListMissionProfilesResponse> {
        private ListMissionProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListMissionProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMissionProfilesResponse nextPage(ListMissionProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListMissionProfilesIterable.this.client.listMissionProfiles(ListMissionProfilesIterable.this.firstRequest);
            }
            return ListMissionProfilesIterable.this.client.listMissionProfiles((ListMissionProfilesRequest)((Object)ListMissionProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

