/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a volume that Linux processes in a container can access. When you define a volume, the IoT
 * Greengrass Core software mounts the source files to the destination inside the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaVolumeMount implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaVolumeMount.Builder, LambdaVolumeMount> {
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourcePath").getter(getter(LambdaVolumeMount::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePath").build()).build();

    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationPath").getter(getter(LambdaVolumeMount::destinationPath))
            .setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPath").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permission").getter(getter(LambdaVolumeMount::permissionAsString)).setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final SdkField<Boolean> ADD_GROUP_OWNER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("addGroupOwner").getter(getter(LambdaVolumeMount::addGroupOwner)).setter(setter(Builder::addGroupOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addGroupOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PATH_FIELD,
            DESTINATION_PATH_FIELD, PERMISSION_FIELD, ADD_GROUP_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourcePath;

    private final String destinationPath;

    private final String permission;

    private final Boolean addGroupOwner;

    private LambdaVolumeMount(BuilderImpl builder) {
        this.sourcePath = builder.sourcePath;
        this.destinationPath = builder.destinationPath;
        this.permission = builder.permission;
        this.addGroupOwner = builder.addGroupOwner;
    }

    /**
     * <p>
     * The path to the physical volume in the file system.
     * </p>
     * 
     * @return The path to the physical volume in the file system.
     */
    public final String sourcePath() {
        return sourcePath;
    }

    /**
     * <p>
     * The path to the logical volume in the file system.
     * </p>
     * 
     * @return The path to the logical volume in the file system.
     */
    public final String destinationPath() {
        return destinationPath;
    }

    /**
     * <p>
     * The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).
     * </p>
     * <p>
     * Default: <code>ro</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link LambdaFilesystemPermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionAsString}.
     * </p>
     * 
     * @return The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
     *         <p>
     *         Default: <code>ro</code>
     * @see LambdaFilesystemPermission
     */
    public final LambdaFilesystemPermission permission() {
        return LambdaFilesystemPermission.fromValue(permission);
    }

    /**
     * <p>
     * The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).
     * </p>
     * <p>
     * Default: <code>ro</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link LambdaFilesystemPermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionAsString}.
     * </p>
     * 
     * @return The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
     *         <p>
     *         Default: <code>ro</code>
     * @see LambdaFilesystemPermission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * Whether or not to add the IoT Greengrass user group as an owner of the volume.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Whether or not to add the IoT Greengrass user group as an owner of the volume.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean addGroupOwner() {
        return addGroupOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addGroupOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaVolumeMount)) {
            return false;
        }
        LambdaVolumeMount other = (LambdaVolumeMount) obj;
        return Objects.equals(sourcePath(), other.sourcePath()) && Objects.equals(destinationPath(), other.destinationPath())
                && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(addGroupOwner(), other.addGroupOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaVolumeMount").add("SourcePath", sourcePath()).add("DestinationPath", destinationPath())
                .add("Permission", permissionAsString()).add("AddGroupOwner", addGroupOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        case "destinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        case "permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "addGroupOwner":
            return Optional.ofNullable(clazz.cast(addGroupOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourcePath", SOURCE_PATH_FIELD);
        map.put("destinationPath", DESTINATION_PATH_FIELD);
        map.put("permission", PERMISSION_FIELD);
        map.put("addGroupOwner", ADD_GROUP_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaVolumeMount, T> g) {
        return obj -> g.apply((LambdaVolumeMount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaVolumeMount> {
        /**
         * <p>
         * The path to the physical volume in the file system.
         * </p>
         * 
         * @param sourcePath
         *        The path to the physical volume in the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);

        /**
         * <p>
         * The path to the logical volume in the file system.
         * </p>
         * 
         * @param destinationPath
         *        The path to the logical volume in the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);

        /**
         * <p>
         * The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).
         * </p>
         * <p>
         * Default: <code>ro</code>
         * </p>
         * 
         * @param permission
         *        The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
         *        <p>
         *        Default: <code>ro</code>
         * @see LambdaFilesystemPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFilesystemPermission
         */
        Builder permission(String permission);

        /**
         * <p>
         * The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).
         * </p>
         * <p>
         * Default: <code>ro</code>
         * </p>
         * 
         * @param permission
         *        The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
         *        <p>
         *        Default: <code>ro</code>
         * @see LambdaFilesystemPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFilesystemPermission
         */
        Builder permission(LambdaFilesystemPermission permission);

        /**
         * <p>
         * Whether or not to add the IoT Greengrass user group as an owner of the volume.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param addGroupOwner
         *        Whether or not to add the IoT Greengrass user group as an owner of the volume.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addGroupOwner(Boolean addGroupOwner);
    }

    static final class BuilderImpl implements Builder {
        private String sourcePath;

        private String destinationPath;

        private String permission;

        private Boolean addGroupOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaVolumeMount model) {
            sourcePath(model.sourcePath);
            destinationPath(model.destinationPath);
            permission(model.permission);
            addGroupOwner(model.addGroupOwner);
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(LambdaFilesystemPermission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Boolean getAddGroupOwner() {
            return addGroupOwner;
        }

        public final void setAddGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
        }

        @Override
        public final Builder addGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
            return this;
        }

        @Override
        public LambdaVolumeMount build() {
            return new LambdaVolumeMount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
