/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a device that Linux processes in a container can access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaDeviceMount implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaDeviceMount.Builder, LambdaDeviceMount> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(LambdaDeviceMount::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permission").getter(getter(LambdaDeviceMount::permissionAsString)).setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final SdkField<Boolean> ADD_GROUP_OWNER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("addGroupOwner").getter(getter(LambdaDeviceMount::addGroupOwner)).setter(setter(Builder::addGroupOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addGroupOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, PERMISSION_FIELD,
            ADD_GROUP_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String permission;

    private final Boolean addGroupOwner;

    private LambdaDeviceMount(BuilderImpl builder) {
        this.path = builder.path;
        this.permission = builder.permission;
        this.addGroupOwner = builder.addGroupOwner;
    }

    /**
     * <p>
     * The mount path for the device in the file system.
     * </p>
     * 
     * @return The mount path for the device in the file system.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).
     * </p>
     * <p>
     * Default: <code>ro</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link LambdaFilesystemPermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionAsString}.
     * </p>
     * 
     * @return The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
     *         <p>
     *         Default: <code>ro</code>
     * @see LambdaFilesystemPermission
     */
    public final LambdaFilesystemPermission permission() {
        return LambdaFilesystemPermission.fromValue(permission);
    }

    /**
     * <p>
     * The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).
     * </p>
     * <p>
     * Default: <code>ro</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link LambdaFilesystemPermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionAsString}.
     * </p>
     * 
     * @return The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
     *         <p>
     *         Default: <code>ro</code>
     * @see LambdaFilesystemPermission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * Whether or not to add the component's system user as an owner of the device.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Whether or not to add the component's system user as an owner of the device.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean addGroupOwner() {
        return addGroupOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addGroupOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaDeviceMount)) {
            return false;
        }
        LambdaDeviceMount other = (LambdaDeviceMount) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(addGroupOwner(), other.addGroupOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaDeviceMount").add("Path", path()).add("Permission", permissionAsString())
                .add("AddGroupOwner", addGroupOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "addGroupOwner":
            return Optional.ofNullable(clazz.cast(addGroupOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("path", PATH_FIELD);
        map.put("permission", PERMISSION_FIELD);
        map.put("addGroupOwner", ADD_GROUP_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaDeviceMount, T> g) {
        return obj -> g.apply((LambdaDeviceMount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaDeviceMount> {
        /**
         * <p>
         * The mount path for the device in the file system.
         * </p>
         * 
         * @param path
         *        The mount path for the device in the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).
         * </p>
         * <p>
         * Default: <code>ro</code>
         * </p>
         * 
         * @param permission
         *        The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
         *        <p>
         *        Default: <code>ro</code>
         * @see LambdaFilesystemPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFilesystemPermission
         */
        Builder permission(String permission);

        /**
         * <p>
         * The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).
         * </p>
         * <p>
         * Default: <code>ro</code>
         * </p>
         * 
         * @param permission
         *        The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p>
         *        <p>
         *        Default: <code>ro</code>
         * @see LambdaFilesystemPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFilesystemPermission
         */
        Builder permission(LambdaFilesystemPermission permission);

        /**
         * <p>
         * Whether or not to add the component's system user as an owner of the device.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param addGroupOwner
         *        Whether or not to add the component's system user as an owner of the device.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addGroupOwner(Boolean addGroupOwner);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String permission;

        private Boolean addGroupOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaDeviceMount model) {
            path(model.path);
            permission(model.permission);
            addGroupOwner(model.addGroupOwner);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(LambdaFilesystemPermission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Boolean getAddGroupOwner() {
            return addGroupOwner;
        }

        public final void setAddGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
        }

        @Override
        public final Builder addGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
            return this;
        }

        @Override
        public LambdaDeviceMount build() {
            return new LambdaDeviceMount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
