/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.ComponentVersionListCopier;
import software.amazon.awssdk.services.greengrassv2.model.ComponentVersionListItem;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentVersionsResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, ListComponentVersionsResponse> {
    private static final SdkField<List<ComponentVersionListItem>> COMPONENT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentVersions").getter(ListComponentVersionsResponse.getter(ListComponentVersionsResponse::componentVersions)).setter(ListComponentVersionsResponse.setter(Builder::componentVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentVersionListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComponentVersionsResponse.getter(ListComponentVersionsResponse::nextToken)).setter(ListComponentVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListComponentVersionsResponse.memberNameToFieldInitializer();
    private final List<ComponentVersionListItem> componentVersions;
    private final String nextToken;

    private ListComponentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.componentVersions = builder.componentVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComponentVersions() {
        return this.componentVersions != null && !(this.componentVersions instanceof SdkAutoConstructList);
    }

    public final List<ComponentVersionListItem> componentVersions() {
        return this.componentVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentVersions() ? this.componentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentVersionsResponse)) {
            return false;
        }
        ListComponentVersionsResponse other = (ListComponentVersionsResponse)((Object)obj);
        return this.hasComponentVersions() == other.hasComponentVersions() && Objects.equals(this.componentVersions(), other.componentVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComponentVersionsResponse").add("ComponentVersions", this.hasComponentVersions() ? this.componentVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentVersions": {
                return Optional.ofNullable(clazz.cast(this.componentVersions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentVersions", COMPONENT_VERSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComponentVersionsResponse, T> g) {
        return obj -> g.apply((ListComponentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private List<ComponentVersionListItem> componentVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentVersionsResponse model) {
            super(model);
            this.componentVersions(model.componentVersions);
            this.nextToken(model.nextToken);
        }

        public final List<ComponentVersionListItem.Builder> getComponentVersions() {
            List<ComponentVersionListItem.Builder> result = ComponentVersionListCopier.copyToBuilder(this.componentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentVersions(Collection<ComponentVersionListItem.BuilderImpl> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copyFromBuilder(componentVersions);
        }

        @Override
        public final Builder componentVersions(Collection<ComponentVersionListItem> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copy(componentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(ComponentVersionListItem ... componentVersions) {
            this.componentVersions(Arrays.asList(componentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(Consumer<ComponentVersionListItem.Builder> ... componentVersions) {
            this.componentVersions(Stream.of(componentVersions).map(c -> (ComponentVersionListItem)((ComponentVersionListItem.Builder)ComponentVersionListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComponentVersionsResponse build() {
            return new ListComponentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComponentVersionsResponse> {
        public Builder componentVersions(Collection<ComponentVersionListItem> var1);

        public Builder componentVersions(ComponentVersionListItem ... var1);

        public Builder componentVersions(Consumer<ComponentVersionListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

