/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeploymentErrorStackCopier;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeploymentErrorTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectiveDeploymentStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectiveDeploymentStatusDetails> {
    private static final SdkField<List<String>> ERROR_STACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorStack").getter(EffectiveDeploymentStatusDetails.getter(EffectiveDeploymentStatusDetails::errorStack)).setter(EffectiveDeploymentStatusDetails.setter(Builder::errorStack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorStack").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ERROR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorTypes").getter(EffectiveDeploymentStatusDetails.getter(EffectiveDeploymentStatusDetails::errorTypes)).setter(EffectiveDeploymentStatusDetails.setter(Builder::errorTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_STACK_FIELD, ERROR_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EffectiveDeploymentStatusDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> errorStack;
    private final List<String> errorTypes;

    private EffectiveDeploymentStatusDetails(BuilderImpl builder) {
        this.errorStack = builder.errorStack;
        this.errorTypes = builder.errorTypes;
    }

    public final boolean hasErrorStack() {
        return this.errorStack != null && !(this.errorStack instanceof SdkAutoConstructList);
    }

    public final List<String> errorStack() {
        return this.errorStack;
    }

    public final boolean hasErrorTypes() {
        return this.errorTypes != null && !(this.errorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> errorTypes() {
        return this.errorTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorStack() ? this.errorStack() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorTypes() ? this.errorTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveDeploymentStatusDetails)) {
            return false;
        }
        EffectiveDeploymentStatusDetails other = (EffectiveDeploymentStatusDetails)obj;
        return this.hasErrorStack() == other.hasErrorStack() && Objects.equals(this.errorStack(), other.errorStack()) && this.hasErrorTypes() == other.hasErrorTypes() && Objects.equals(this.errorTypes(), other.errorTypes());
    }

    public final String toString() {
        return ToString.builder((String)"EffectiveDeploymentStatusDetails").add("ErrorStack", this.hasErrorStack() ? this.errorStack() : null).add("ErrorTypes", this.hasErrorTypes() ? this.errorTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorStack": {
                return Optional.ofNullable(clazz.cast(this.errorStack()));
            }
            case "errorTypes": {
                return Optional.ofNullable(clazz.cast(this.errorTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("errorStack", ERROR_STACK_FIELD);
        map.put("errorTypes", ERROR_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectiveDeploymentStatusDetails, T> g) {
        return obj -> g.apply((EffectiveDeploymentStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> errorStack = DefaultSdkAutoConstructList.getInstance();
        private List<String> errorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveDeploymentStatusDetails model) {
            this.errorStack(model.errorStack);
            this.errorTypes(model.errorTypes);
        }

        public final Collection<String> getErrorStack() {
            if (this.errorStack instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errorStack;
        }

        public final void setErrorStack(Collection<String> errorStack) {
            this.errorStack = EffectiveDeploymentErrorStackCopier.copy(errorStack);
        }

        @Override
        public final Builder errorStack(Collection<String> errorStack) {
            this.errorStack = EffectiveDeploymentErrorStackCopier.copy(errorStack);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorStack(String ... errorStack) {
            this.errorStack(Arrays.asList(errorStack));
            return this;
        }

        public final Collection<String> getErrorTypes() {
            if (this.errorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errorTypes;
        }

        public final void setErrorTypes(Collection<String> errorTypes) {
            this.errorTypes = EffectiveDeploymentErrorTypeListCopier.copy(errorTypes);
        }

        @Override
        public final Builder errorTypes(Collection<String> errorTypes) {
            this.errorTypes = EffectiveDeploymentErrorTypeListCopier.copy(errorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorTypes(String ... errorTypes) {
            this.errorTypes(Arrays.asList(errorTypes));
            return this;
        }

        public EffectiveDeploymentStatusDetails build() {
            return new EffectiveDeploymentStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectiveDeploymentStatusDetails> {
        public Builder errorStack(Collection<String> var1);

        public Builder errorStack(String ... var1);

        public Builder errorTypes(Collection<String> var1);

        public Builder errorTypes(String ... var1);
    }
}

