/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.LambdaDeviceListCopier;
import software.amazon.awssdk.services.greengrassv2.model.LambdaDeviceMount;
import software.amazon.awssdk.services.greengrassv2.model.LambdaVolumeListCopier;
import software.amazon.awssdk.services.greengrassv2.model.LambdaVolumeMount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaContainerParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaContainerParams> {
    private static final SdkField<Integer> MEMORY_SIZE_IN_KB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInKB").getter(LambdaContainerParams.getter(LambdaContainerParams::memorySizeInKB)).setter(LambdaContainerParams.setter(Builder::memorySizeInKB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInKB").build()}).build();
    private static final SdkField<Boolean> MOUNT_RO_SYSFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("mountROSysfs").getter(LambdaContainerParams.getter(LambdaContainerParams::mountROSysfs)).setter(LambdaContainerParams.setter(Builder::mountROSysfs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountROSysfs").build()}).build();
    private static final SdkField<List<LambdaVolumeMount>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(LambdaContainerParams.getter(LambdaContainerParams::volumes)).setter(LambdaContainerParams.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaVolumeMount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LambdaDeviceMount>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("devices").getter(LambdaContainerParams.getter(LambdaContainerParams::devices)).setter(LambdaContainerParams.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaDeviceMount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_SIZE_IN_KB_FIELD, MOUNT_RO_SYSFS_FIELD, VOLUMES_FIELD, DEVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaContainerParams.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer memorySizeInKB;
    private final Boolean mountROSysfs;
    private final List<LambdaVolumeMount> volumes;
    private final List<LambdaDeviceMount> devices;

    private LambdaContainerParams(BuilderImpl builder) {
        this.memorySizeInKB = builder.memorySizeInKB;
        this.mountROSysfs = builder.mountROSysfs;
        this.volumes = builder.volumes;
        this.devices = builder.devices;
    }

    public final Integer memorySizeInKB() {
        return this.memorySizeInKB;
    }

    public final Boolean mountROSysfs() {
        return this.mountROSysfs;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<LambdaVolumeMount> volumes() {
        return this.volumes;
    }

    public final boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructList);
    }

    public final List<LambdaDeviceMount> devices() {
        return this.devices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInKB());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountROSysfs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaContainerParams)) {
            return false;
        }
        LambdaContainerParams other = (LambdaContainerParams)obj;
        return Objects.equals(this.memorySizeInKB(), other.memorySizeInKB()) && Objects.equals(this.mountROSysfs(), other.mountROSysfs()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaContainerParams").add("MemorySizeInKB", (Object)this.memorySizeInKB()).add("MountROSysfs", (Object)this.mountROSysfs()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Devices", this.hasDevices() ? this.devices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memorySizeInKB": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInKB()));
            }
            case "mountROSysfs": {
                return Optional.ofNullable(clazz.cast(this.mountROSysfs()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memorySizeInKB", MEMORY_SIZE_IN_KB_FIELD);
        map.put("mountROSysfs", MOUNT_RO_SYSFS_FIELD);
        map.put("volumes", VOLUMES_FIELD);
        map.put("devices", DEVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaContainerParams, T> g) {
        return obj -> g.apply((LambdaContainerParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer memorySizeInKB;
        private Boolean mountROSysfs;
        private List<LambdaVolumeMount> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<LambdaDeviceMount> devices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaContainerParams model) {
            this.memorySizeInKB(model.memorySizeInKB);
            this.mountROSysfs(model.mountROSysfs);
            this.volumes(model.volumes);
            this.devices(model.devices);
        }

        public final Integer getMemorySizeInKB() {
            return this.memorySizeInKB;
        }

        public final void setMemorySizeInKB(Integer memorySizeInKB) {
            this.memorySizeInKB = memorySizeInKB;
        }

        @Override
        public final Builder memorySizeInKB(Integer memorySizeInKB) {
            this.memorySizeInKB = memorySizeInKB;
            return this;
        }

        public final Boolean getMountROSysfs() {
            return this.mountROSysfs;
        }

        public final void setMountROSysfs(Boolean mountROSysfs) {
            this.mountROSysfs = mountROSysfs;
        }

        @Override
        public final Builder mountROSysfs(Boolean mountROSysfs) {
            this.mountROSysfs = mountROSysfs;
            return this;
        }

        public final List<LambdaVolumeMount.Builder> getVolumes() {
            List<LambdaVolumeMount.Builder> result = LambdaVolumeListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<LambdaVolumeMount.BuilderImpl> volumes) {
            this.volumes = LambdaVolumeListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<LambdaVolumeMount> volumes) {
            this.volumes = LambdaVolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(LambdaVolumeMount ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<LambdaVolumeMount.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (LambdaVolumeMount)((LambdaVolumeMount.Builder)LambdaVolumeMount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LambdaDeviceMount.Builder> getDevices() {
            List<LambdaDeviceMount.Builder> result = LambdaDeviceListCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<LambdaDeviceMount.BuilderImpl> devices) {
            this.devices = LambdaDeviceListCopier.copyFromBuilder(devices);
        }

        @Override
        public final Builder devices(Collection<LambdaDeviceMount> devices) {
            this.devices = LambdaDeviceListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(LambdaDeviceMount ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<LambdaDeviceMount.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (LambdaDeviceMount)((LambdaDeviceMount.Builder)LambdaDeviceMount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LambdaContainerParams build() {
            return new LambdaContainerParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaContainerParams> {
        public Builder memorySizeInKB(Integer var1);

        public Builder mountROSysfs(Boolean var1);

        public Builder volumes(Collection<LambdaVolumeMount> var1);

        public Builder volumes(LambdaVolumeMount ... var1);

        public Builder volumes(Consumer<LambdaVolumeMount.Builder> ... var1);

        public Builder devices(Collection<LambdaDeviceMount> var1);

        public Builder devices(LambdaDeviceMount ... var1);

        public Builder devices(Consumer<LambdaDeviceMount.Builder> ... var1);
    }
}

