/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.IoTJobExponentialRolloutRate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IoTJobExecutionsRolloutConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IoTJobExecutionsRolloutConfig> {
    private static final SdkField<IoTJobExponentialRolloutRate> EXPONENTIAL_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exponentialRate").getter(IoTJobExecutionsRolloutConfig.getter(IoTJobExecutionsRolloutConfig::exponentialRate)).setter(IoTJobExecutionsRolloutConfig.setter(Builder::exponentialRate)).constructor(IoTJobExponentialRolloutRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exponentialRate").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPerMinute").getter(IoTJobExecutionsRolloutConfig.getter(IoTJobExecutionsRolloutConfig::maximumPerMinute)).setter(IoTJobExecutionsRolloutConfig.setter(Builder::maximumPerMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPONENTIAL_RATE_FIELD, MAXIMUM_PER_MINUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("exponentialRate", EXPONENTIAL_RATE_FIELD);
            this.put("maximumPerMinute", MAXIMUM_PER_MINUTE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final IoTJobExponentialRolloutRate exponentialRate;
    private final Integer maximumPerMinute;

    private IoTJobExecutionsRolloutConfig(BuilderImpl builder) {
        this.exponentialRate = builder.exponentialRate;
        this.maximumPerMinute = builder.maximumPerMinute;
    }

    public final IoTJobExponentialRolloutRate exponentialRate() {
        return this.exponentialRate;
    }

    public final Integer maximumPerMinute() {
        return this.maximumPerMinute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exponentialRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPerMinute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IoTJobExecutionsRolloutConfig)) {
            return false;
        }
        IoTJobExecutionsRolloutConfig other = (IoTJobExecutionsRolloutConfig)obj;
        return Objects.equals(this.exponentialRate(), other.exponentialRate()) && Objects.equals(this.maximumPerMinute(), other.maximumPerMinute());
    }

    public final String toString() {
        return ToString.builder((String)"IoTJobExecutionsRolloutConfig").add("ExponentialRate", (Object)this.exponentialRate()).add("MaximumPerMinute", (Object)this.maximumPerMinute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exponentialRate": {
                return Optional.ofNullable(clazz.cast(this.exponentialRate()));
            }
            case "maximumPerMinute": {
                return Optional.ofNullable(clazz.cast(this.maximumPerMinute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IoTJobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((IoTJobExecutionsRolloutConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IoTJobExponentialRolloutRate exponentialRate;
        private Integer maximumPerMinute;

        private BuilderImpl() {
        }

        private BuilderImpl(IoTJobExecutionsRolloutConfig model) {
            this.exponentialRate(model.exponentialRate);
            this.maximumPerMinute(model.maximumPerMinute);
        }

        public final IoTJobExponentialRolloutRate.Builder getExponentialRate() {
            return this.exponentialRate != null ? this.exponentialRate.toBuilder() : null;
        }

        public final void setExponentialRate(IoTJobExponentialRolloutRate.BuilderImpl exponentialRate) {
            this.exponentialRate = exponentialRate != null ? exponentialRate.build() : null;
        }

        @Override
        public final Builder exponentialRate(IoTJobExponentialRolloutRate exponentialRate) {
            this.exponentialRate = exponentialRate;
            return this;
        }

        public final Integer getMaximumPerMinute() {
            return this.maximumPerMinute;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public IoTJobExecutionsRolloutConfig build() {
            return new IoTJobExecutionsRolloutConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IoTJobExecutionsRolloutConfig> {
        public Builder exponentialRate(IoTJobExponentialRolloutRate var1);

        default public Builder exponentialRate(Consumer<IoTJobExponentialRolloutRate.Builder> exponentialRate) {
            return this.exponentialRate((IoTJobExponentialRolloutRate)((IoTJobExponentialRolloutRate.Builder)IoTJobExponentialRolloutRate.builder().applyMutation(exponentialRate)).build());
        }

        public Builder maximumPerMinute(Integer var1);
    }
}

