/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.InstalledComponent;
import software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse;

public class ListInstalledComponentsPublisher
implements SdkPublisher<ListInstalledComponentsResponse> {
    private final GreengrassV2AsyncClient client;
    private final ListInstalledComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstalledComponentsPublisher(GreengrassV2AsyncClient client, ListInstalledComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstalledComponentsPublisher(GreengrassV2AsyncClient client, ListInstalledComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstalledComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstalledComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstalledComponent> installedComponents() {
        Function<ListInstalledComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.installedComponents() != null) {
                return response.installedComponents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstalledComponentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInstalledComponentsResponseFetcher
    implements AsyncPageFetcher<ListInstalledComponentsResponse> {
        private ListInstalledComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstalledComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInstalledComponentsResponse> nextPage(ListInstalledComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListInstalledComponentsPublisher.this.client.listInstalledComponents(ListInstalledComponentsPublisher.this.firstRequest);
            }
            return ListInstalledComponentsPublisher.this.client.listInstalledComponents((ListInstalledComponentsRequest)((Object)ListInstalledComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

