/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceEntry;
import software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceEntryListCopier;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateClientDeviceWithCoreDeviceRequest
extends GreengrassV2Request
implements ToCopyableBuilder<Builder, BatchAssociateClientDeviceWithCoreDeviceRequest> {
    private static final SdkField<List<AssociateClientDeviceWithCoreDeviceEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entries").getter(BatchAssociateClientDeviceWithCoreDeviceRequest.getter(BatchAssociateClientDeviceWithCoreDeviceRequest::entries)).setter(BatchAssociateClientDeviceWithCoreDeviceRequest.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociateClientDeviceWithCoreDeviceEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coreDeviceThingName").getter(BatchAssociateClientDeviceWithCoreDeviceRequest.getter(BatchAssociateClientDeviceWithCoreDeviceRequest::coreDeviceThingName)).setter(BatchAssociateClientDeviceWithCoreDeviceRequest.setter(Builder::coreDeviceThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreDeviceThingName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD, CORE_DEVICE_THING_NAME_FIELD));
    private final List<AssociateClientDeviceWithCoreDeviceEntry> entries;
    private final String coreDeviceThingName;

    private BatchAssociateClientDeviceWithCoreDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.coreDeviceThingName = builder.coreDeviceThingName;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<AssociateClientDeviceWithCoreDeviceEntry> entries() {
        return this.entries;
    }

    public final String coreDeviceThingName() {
        return this.coreDeviceThingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDeviceThingName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateClientDeviceWithCoreDeviceRequest)) {
            return false;
        }
        BatchAssociateClientDeviceWithCoreDeviceRequest other = (BatchAssociateClientDeviceWithCoreDeviceRequest)((Object)obj);
        return this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.coreDeviceThingName(), other.coreDeviceThingName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateClientDeviceWithCoreDeviceRequest").add("Entries", this.hasEntries() ? this.entries() : null).add("CoreDeviceThingName", (Object)this.coreDeviceThingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "coreDeviceThingName": {
                return Optional.ofNullable(clazz.cast(this.coreDeviceThingName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateClientDeviceWithCoreDeviceRequest, T> g) {
        return obj -> g.apply((BatchAssociateClientDeviceWithCoreDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Request.BuilderImpl
    implements Builder {
        private List<AssociateClientDeviceWithCoreDeviceEntry> entries = DefaultSdkAutoConstructList.getInstance();
        private String coreDeviceThingName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateClientDeviceWithCoreDeviceRequest model) {
            super(model);
            this.entries(model.entries);
            this.coreDeviceThingName(model.coreDeviceThingName);
        }

        public final List<AssociateClientDeviceWithCoreDeviceEntry.Builder> getEntries() {
            List<AssociateClientDeviceWithCoreDeviceEntry.Builder> result = AssociateClientDeviceWithCoreDeviceEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<AssociateClientDeviceWithCoreDeviceEntry.BuilderImpl> entries) {
            this.entries = AssociateClientDeviceWithCoreDeviceEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<AssociateClientDeviceWithCoreDeviceEntry> entries) {
            this.entries = AssociateClientDeviceWithCoreDeviceEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(AssociateClientDeviceWithCoreDeviceEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<AssociateClientDeviceWithCoreDeviceEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (AssociateClientDeviceWithCoreDeviceEntry)((AssociateClientDeviceWithCoreDeviceEntry.Builder)AssociateClientDeviceWithCoreDeviceEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCoreDeviceThingName() {
            return this.coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateClientDeviceWithCoreDeviceRequest build() {
            return new BatchAssociateClientDeviceWithCoreDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateClientDeviceWithCoreDeviceRequest> {
        public Builder entries(Collection<AssociateClientDeviceWithCoreDeviceEntry> var1);

        public Builder entries(AssociateClientDeviceWithCoreDeviceEntry ... var1);

        public Builder entries(Consumer<AssociateClientDeviceWithCoreDeviceEntry.Builder> ... var1);

        public Builder coreDeviceThingName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

