/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentResponse extends GreengrassV2Response implements
        ToCopyableBuilder<GetComponentResponse.Builder, GetComponentResponse> {
    private static final SdkField<String> RECIPE_OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeOutputFormat").getter(getter(GetComponentResponse::recipeOutputFormatAsString))
            .setter(setter(Builder::recipeOutputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeOutputFormat").build())
            .build();

    private static final SdkField<SdkBytes> RECIPE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("recipe").getter(getter(GetComponentResponse::recipe)).setter(setter(Builder::recipe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetComponentResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_OUTPUT_FORMAT_FIELD,
            RECIPE_FIELD, TAGS_FIELD));

    private final String recipeOutputFormat;

    private final SdkBytes recipe;

    private final Map<String, String> tags;

    private GetComponentResponse(BuilderImpl builder) {
        super(builder);
        this.recipeOutputFormat = builder.recipeOutputFormat;
        this.recipe = builder.recipe;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The format of the recipe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recipeOutputFormat} will return {@link RecipeOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recipeOutputFormatAsString}.
     * </p>
     * 
     * @return The format of the recipe.
     * @see RecipeOutputFormat
     */
    public final RecipeOutputFormat recipeOutputFormat() {
        return RecipeOutputFormat.fromValue(recipeOutputFormat);
    }

    /**
     * <p>
     * The format of the recipe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recipeOutputFormat} will return {@link RecipeOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recipeOutputFormatAsString}.
     * </p>
     * 
     * @return The format of the recipe.
     * @see RecipeOutputFormat
     */
    public final String recipeOutputFormatAsString() {
        return recipeOutputFormat;
    }

    /**
     * <p>
     * The recipe of the component version.
     * </p>
     * 
     * @return The recipe of the component version.
     */
    public final SdkBytes recipe() {
        return recipe;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the resource. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the
     * <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a>
     *         in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recipeOutputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recipe());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentResponse)) {
            return false;
        }
        GetComponentResponse other = (GetComponentResponse) obj;
        return Objects.equals(recipeOutputFormatAsString(), other.recipeOutputFormatAsString())
                && Objects.equals(recipe(), other.recipe()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComponentResponse").add("RecipeOutputFormat", recipeOutputFormatAsString())
                .add("Recipe", recipe()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recipeOutputFormat":
            return Optional.ofNullable(clazz.cast(recipeOutputFormatAsString()));
        case "recipe":
            return Optional.ofNullable(clazz.cast(recipe()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentResponse, T> g) {
        return obj -> g.apply((GetComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetComponentResponse> {
        /**
         * <p>
         * The format of the recipe.
         * </p>
         * 
         * @param recipeOutputFormat
         *        The format of the recipe.
         * @see RecipeOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecipeOutputFormat
         */
        Builder recipeOutputFormat(String recipeOutputFormat);

        /**
         * <p>
         * The format of the recipe.
         * </p>
         * 
         * @param recipeOutputFormat
         *        The format of the recipe.
         * @see RecipeOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecipeOutputFormat
         */
        Builder recipeOutputFormat(RecipeOutputFormat recipeOutputFormat);

        /**
         * <p>
         * The recipe of the component version.
         * </p>
         * 
         * @param recipe
         *        The recipe of the component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(SdkBytes recipe);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the resource. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in
         * the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         *        resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String recipeOutputFormat;

        private SdkBytes recipe;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentResponse model) {
            super(model);
            recipeOutputFormat(model.recipeOutputFormat);
            recipe(model.recipe);
            tags(model.tags);
        }

        public final String getRecipeOutputFormat() {
            return recipeOutputFormat;
        }

        public final void setRecipeOutputFormat(String recipeOutputFormat) {
            this.recipeOutputFormat = recipeOutputFormat;
        }

        @Override
        public final Builder recipeOutputFormat(String recipeOutputFormat) {
            this.recipeOutputFormat = recipeOutputFormat;
            return this;
        }

        @Override
        public final Builder recipeOutputFormat(RecipeOutputFormat recipeOutputFormat) {
            this.recipeOutputFormat(recipeOutputFormat == null ? null : recipeOutputFormat.toString());
            return this;
        }

        public final ByteBuffer getRecipe() {
            return recipe == null ? null : recipe.asByteBuffer();
        }

        public final void setRecipe(ByteBuffer recipe) {
            recipe(recipe == null ? null : SdkBytes.fromByteBuffer(recipe));
        }

        @Override
        public final Builder recipe(SdkBytes recipe) {
            this.recipe = recipe;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetComponentResponse build() {
            return new GetComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
