/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CloudComponentState {
    REQUESTED("REQUESTED"),
    INITIATED("INITIATED"),
    DEPLOYABLE("DEPLOYABLE"),
    FAILED("FAILED"),
    DEPRECATED("DEPRECATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CloudComponentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudComponentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CloudComponentState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudComponentState> knownValues() {
        return Stream.of(CloudComponentState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

