/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.LambdaFilesystemPermission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaVolumeMount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaVolumeMount> {
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourcePath").getter(LambdaVolumeMount.getter(LambdaVolumeMount::sourcePath)).setter(LambdaVolumeMount.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePath").build()}).build();
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationPath").getter(LambdaVolumeMount.getter(LambdaVolumeMount::destinationPath)).setter(LambdaVolumeMount.setter(Builder::destinationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPath").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permission").getter(LambdaVolumeMount.getter(LambdaVolumeMount::permissionAsString)).setter(LambdaVolumeMount.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()}).build();
    private static final SdkField<Boolean> ADD_GROUP_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("addGroupOwner").getter(LambdaVolumeMount.getter(LambdaVolumeMount::addGroupOwner)).setter(LambdaVolumeMount.setter(Builder::addGroupOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addGroupOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PATH_FIELD, DESTINATION_PATH_FIELD, PERMISSION_FIELD, ADD_GROUP_OWNER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourcePath;
    private final String destinationPath;
    private final String permission;
    private final Boolean addGroupOwner;

    private LambdaVolumeMount(BuilderImpl builder) {
        this.sourcePath = builder.sourcePath;
        this.destinationPath = builder.destinationPath;
        this.permission = builder.permission;
        this.addGroupOwner = builder.addGroupOwner;
    }

    public final String sourcePath() {
        return this.sourcePath;
    }

    public final String destinationPath() {
        return this.destinationPath;
    }

    public final LambdaFilesystemPermission permission() {
        return LambdaFilesystemPermission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final Boolean addGroupOwner() {
        return this.addGroupOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addGroupOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaVolumeMount)) {
            return false;
        }
        LambdaVolumeMount other = (LambdaVolumeMount)obj;
        return Objects.equals(this.sourcePath(), other.sourcePath()) && Objects.equals(this.destinationPath(), other.destinationPath()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.addGroupOwner(), other.addGroupOwner());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaVolumeMount").add("SourcePath", (Object)this.sourcePath()).add("DestinationPath", (Object)this.destinationPath()).add("Permission", (Object)this.permissionAsString()).add("AddGroupOwner", (Object)this.addGroupOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
            case "destinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
            case "permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "addGroupOwner": {
                return Optional.ofNullable(clazz.cast(this.addGroupOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaVolumeMount, T> g) {
        return obj -> g.apply((LambdaVolumeMount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourcePath;
        private String destinationPath;
        private String permission;
        private Boolean addGroupOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaVolumeMount model) {
            this.sourcePath(model.sourcePath);
            this.destinationPath(model.destinationPath);
            this.permission(model.permission);
            this.addGroupOwner(model.addGroupOwner);
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(LambdaFilesystemPermission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final Boolean getAddGroupOwner() {
            return this.addGroupOwner;
        }

        @Override
        public final Builder addGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
            return this;
        }

        public final void setAddGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
        }

        public LambdaVolumeMount build() {
            return new LambdaVolumeMount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaVolumeMount> {
        public Builder sourcePath(String var1);

        public Builder destinationPath(String var1);

        public Builder permission(String var1);

        public Builder permission(LambdaFilesystemPermission var1);

        public Builder addGroupOwner(Boolean var1);
    }
}

