/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.FunctionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Function
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Function> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Function.getter(Function::functionArn)).setter(Function.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<FunctionConfiguration> FUNCTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Function.getter(Function::functionConfiguration)).setter(Function.setter(Builder::functionConfiguration)).constructor(FunctionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionConfiguration").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Function.getter(Function::id)).setter(Function.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, FUNCTION_CONFIGURATION_FIELD, ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionArn;
    private final FunctionConfiguration functionConfiguration;
    private final String id;

    private Function(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.functionConfiguration = builder.functionConfiguration;
        this.id = builder.id;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public FunctionConfiguration functionConfiguration() {
        return this.functionConfiguration;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        return Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.functionConfiguration(), other.functionConfiguration()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        return ToString.builder((String)"Function").add("FunctionArn", (Object)this.functionArn()).add("FunctionConfiguration", (Object)this.functionConfiguration()).add("Id", (Object)this.id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "FunctionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.functionConfiguration()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<Function, T> g) {
        return obj -> g.apply((Function)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionArn;
        private FunctionConfiguration functionConfiguration;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(Function model) {
            this.functionArn(model.functionArn);
            this.functionConfiguration(model.functionConfiguration);
            this.id(model.id);
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final FunctionConfiguration.Builder getFunctionConfiguration() {
            return this.functionConfiguration != null ? this.functionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder functionConfiguration(FunctionConfiguration functionConfiguration) {
            this.functionConfiguration = functionConfiguration;
            return this;
        }

        public final void setFunctionConfiguration(FunctionConfiguration.BuilderImpl functionConfiguration) {
            this.functionConfiguration = functionConfiguration != null ? functionConfiguration.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public Function build() {
            return new Function(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Function> {
        public Builder functionArn(String var1);

        public Builder functionConfiguration(FunctionConfiguration var1);

        default public Builder functionConfiguration(Consumer<FunctionConfiguration.Builder> functionConfiguration) {
            return this.functionConfiguration((FunctionConfiguration)((FunctionConfiguration.Builder)FunctionConfiguration.builder().applyMutation(functionConfiguration)).build());
        }

        public Builder id(String var1);
    }
}

