/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, GetDeviceDefinitionVersionRequest> {
    private static final SdkField<String> DEVICE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionVersionRequest.getter(GetDeviceDefinitionVersionRequest::deviceDefinitionId)).setter(GetDeviceDefinitionVersionRequest.setter(Builder::deviceDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceDefinitionId").build()}).build();
    private static final SdkField<String> DEVICE_DEFINITION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionVersionRequest.getter(GetDeviceDefinitionVersionRequest::deviceDefinitionVersionId)).setter(GetDeviceDefinitionVersionRequest.setter(Builder::deviceDefinitionVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceDefinitionVersionId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionVersionRequest.getter(GetDeviceDefinitionVersionRequest::nextToken)).setter(GetDeviceDefinitionVersionRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_DEFINITION_ID_FIELD, DEVICE_DEFINITION_VERSION_ID_FIELD, NEXT_TOKEN_FIELD));
    private final String deviceDefinitionId;
    private final String deviceDefinitionVersionId;
    private final String nextToken;

    private GetDeviceDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceDefinitionId = builder.deviceDefinitionId;
        this.deviceDefinitionVersionId = builder.deviceDefinitionVersionId;
        this.nextToken = builder.nextToken;
    }

    public String deviceDefinitionId() {
        return this.deviceDefinitionId;
    }

    public String deviceDefinitionVersionId() {
        return this.deviceDefinitionVersionId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDefinitionVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceDefinitionVersionRequest)) {
            return false;
        }
        GetDeviceDefinitionVersionRequest other = (GetDeviceDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.deviceDefinitionId(), other.deviceDefinitionId()) && Objects.equals(this.deviceDefinitionVersionId(), other.deviceDefinitionVersionId()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDeviceDefinitionVersionRequest").add("DeviceDefinitionId", (Object)this.deviceDefinitionId()).add("DeviceDefinitionVersionId", (Object)this.deviceDefinitionVersionId()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.deviceDefinitionId()));
            }
            case "DeviceDefinitionVersionId": {
                return Optional.ofNullable(clazz.cast(this.deviceDefinitionVersionId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceDefinitionVersionRequest, T> g) {
        return obj -> g.apply((GetDeviceDefinitionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String deviceDefinitionId;
        private String deviceDefinitionVersionId;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceDefinitionVersionRequest model) {
            super(model);
            this.deviceDefinitionId(model.deviceDefinitionId);
            this.deviceDefinitionVersionId(model.deviceDefinitionVersionId);
            this.nextToken(model.nextToken);
        }

        public final String getDeviceDefinitionId() {
            return this.deviceDefinitionId;
        }

        @Override
        public final Builder deviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        public final void setDeviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
        }

        public final String getDeviceDefinitionVersionId() {
            return this.deviceDefinitionVersionId;
        }

        @Override
        public final Builder deviceDefinitionVersionId(String deviceDefinitionVersionId) {
            this.deviceDefinitionVersionId = deviceDefinitionVersionId;
            return this;
        }

        public final void setDeviceDefinitionVersionId(String deviceDefinitionVersionId) {
            this.deviceDefinitionVersionId = deviceDefinitionVersionId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeviceDefinitionVersionRequest build() {
            return new GetDeviceDefinitionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceDefinitionVersionRequest> {
        public Builder deviceDefinitionId(String var1);

        public Builder deviceDefinitionVersionId(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

