/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedRoleResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, GetAssociatedRoleResponse> {
    private static final SdkField<String> ASSOCIATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssociatedRoleResponse.getter(GetAssociatedRoleResponse::associatedAt)).setter(GetAssociatedRoleResponse.setter(Builder::associatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedAt").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAssociatedRoleResponse.getter(GetAssociatedRoleResponse::roleArn)).setter(GetAssociatedRoleResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_AT_FIELD, ROLE_ARN_FIELD));
    private final String associatedAt;
    private final String roleArn;

    private GetAssociatedRoleResponse(BuilderImpl builder) {
        super(builder);
        this.associatedAt = builder.associatedAt;
        this.roleArn = builder.roleArn;
    }

    public String associatedAt() {
        return this.associatedAt;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedRoleResponse)) {
            return false;
        }
        GetAssociatedRoleResponse other = (GetAssociatedRoleResponse)((Object)obj);
        return Objects.equals(this.associatedAt(), other.associatedAt()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"GetAssociatedRoleResponse").add("AssociatedAt", (Object)this.associatedAt()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedAt": {
                return Optional.ofNullable(clazz.cast(this.associatedAt()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedRoleResponse, T> g) {
        return obj -> g.apply((GetAssociatedRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String associatedAt;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedRoleResponse model) {
            super(model);
            this.associatedAt(model.associatedAt);
            this.roleArn(model.roleArn);
        }

        public final String getAssociatedAt() {
            return this.associatedAt;
        }

        @Override
        public final Builder associatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
            return this;
        }

        public final void setAssociatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public GetAssociatedRoleResponse build() {
            return new GetAssociatedRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedRoleResponse> {
        public Builder associatedAt(String var1);

        public Builder roleArn(String var1);
    }
}

