/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.LocalDeviceResourceData;
import software.amazon.awssdk.services.greengrass.model.LocalVolumeResourceData;
import software.amazon.awssdk.services.greengrass.model.S3MachineLearningModelResourceData;
import software.amazon.awssdk.services.greengrass.model.SageMakerMachineLearningModelResourceData;
import software.amazon.awssdk.services.greengrass.model.SecretsManagerSecretResourceData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDataContainer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDataContainer> {
    private static final SdkField<LocalDeviceResourceData> LOCAL_DEVICE_RESOURCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalDeviceResourceData").getter(ResourceDataContainer.getter(ResourceDataContainer::localDeviceResourceData)).setter(ResourceDataContainer.setter(Builder::localDeviceResourceData)).constructor(LocalDeviceResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeviceResourceData").build()}).build();
    private static final SdkField<LocalVolumeResourceData> LOCAL_VOLUME_RESOURCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalVolumeResourceData").getter(ResourceDataContainer.getter(ResourceDataContainer::localVolumeResourceData)).setter(ResourceDataContainer.setter(Builder::localVolumeResourceData)).constructor(LocalVolumeResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalVolumeResourceData").build()}).build();
    private static final SdkField<S3MachineLearningModelResourceData> S3_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3MachineLearningModelResourceData").getter(ResourceDataContainer.getter(ResourceDataContainer::s3MachineLearningModelResourceData)).setter(ResourceDataContainer.setter(Builder::s3MachineLearningModelResourceData)).constructor(S3MachineLearningModelResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3MachineLearningModelResourceData").build()}).build();
    private static final SdkField<SageMakerMachineLearningModelResourceData> SAGE_MAKER_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SageMakerMachineLearningModelResourceData").getter(ResourceDataContainer.getter(ResourceDataContainer::sageMakerMachineLearningModelResourceData)).setter(ResourceDataContainer.setter(Builder::sageMakerMachineLearningModelResourceData)).constructor(SageMakerMachineLearningModelResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerMachineLearningModelResourceData").build()}).build();
    private static final SdkField<SecretsManagerSecretResourceData> SECRETS_MANAGER_SECRET_RESOURCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManagerSecretResourceData").getter(ResourceDataContainer.getter(ResourceDataContainer::secretsManagerSecretResourceData)).setter(ResourceDataContainer.setter(Builder::secretsManagerSecretResourceData)).constructor(SecretsManagerSecretResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretResourceData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DEVICE_RESOURCE_DATA_FIELD, LOCAL_VOLUME_RESOURCE_DATA_FIELD, S3_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD, SAGE_MAKER_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD, SECRETS_MANAGER_SECRET_RESOURCE_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceDataContainer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LocalDeviceResourceData localDeviceResourceData;
    private final LocalVolumeResourceData localVolumeResourceData;
    private final S3MachineLearningModelResourceData s3MachineLearningModelResourceData;
    private final SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData;
    private final SecretsManagerSecretResourceData secretsManagerSecretResourceData;

    private ResourceDataContainer(BuilderImpl builder) {
        this.localDeviceResourceData = builder.localDeviceResourceData;
        this.localVolumeResourceData = builder.localVolumeResourceData;
        this.s3MachineLearningModelResourceData = builder.s3MachineLearningModelResourceData;
        this.sageMakerMachineLearningModelResourceData = builder.sageMakerMachineLearningModelResourceData;
        this.secretsManagerSecretResourceData = builder.secretsManagerSecretResourceData;
    }

    public final LocalDeviceResourceData localDeviceResourceData() {
        return this.localDeviceResourceData;
    }

    public final LocalVolumeResourceData localVolumeResourceData() {
        return this.localVolumeResourceData;
    }

    public final S3MachineLearningModelResourceData s3MachineLearningModelResourceData() {
        return this.s3MachineLearningModelResourceData;
    }

    public final SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData() {
        return this.sageMakerMachineLearningModelResourceData;
    }

    public final SecretsManagerSecretResourceData secretsManagerSecretResourceData() {
        return this.secretsManagerSecretResourceData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localDeviceResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.localVolumeResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3MachineLearningModelResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerMachineLearningModelResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretResourceData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataContainer)) {
            return false;
        }
        ResourceDataContainer other = (ResourceDataContainer)obj;
        return Objects.equals(this.localDeviceResourceData(), other.localDeviceResourceData()) && Objects.equals(this.localVolumeResourceData(), other.localVolumeResourceData()) && Objects.equals(this.s3MachineLearningModelResourceData(), other.s3MachineLearningModelResourceData()) && Objects.equals(this.sageMakerMachineLearningModelResourceData(), other.sageMakerMachineLearningModelResourceData()) && Objects.equals(this.secretsManagerSecretResourceData(), other.secretsManagerSecretResourceData());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDataContainer").add("LocalDeviceResourceData", (Object)this.localDeviceResourceData()).add("LocalVolumeResourceData", (Object)this.localVolumeResourceData()).add("S3MachineLearningModelResourceData", (Object)this.s3MachineLearningModelResourceData()).add("SageMakerMachineLearningModelResourceData", (Object)this.sageMakerMachineLearningModelResourceData()).add("SecretsManagerSecretResourceData", (Object)this.secretsManagerSecretResourceData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalDeviceResourceData": {
                return Optional.ofNullable(clazz.cast(this.localDeviceResourceData()));
            }
            case "LocalVolumeResourceData": {
                return Optional.ofNullable(clazz.cast(this.localVolumeResourceData()));
            }
            case "S3MachineLearningModelResourceData": {
                return Optional.ofNullable(clazz.cast(this.s3MachineLearningModelResourceData()));
            }
            case "SageMakerMachineLearningModelResourceData": {
                return Optional.ofNullable(clazz.cast(this.sageMakerMachineLearningModelResourceData()));
            }
            case "SecretsManagerSecretResourceData": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretResourceData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocalDeviceResourceData", LOCAL_DEVICE_RESOURCE_DATA_FIELD);
        map.put("LocalVolumeResourceData", LOCAL_VOLUME_RESOURCE_DATA_FIELD);
        map.put("S3MachineLearningModelResourceData", S3_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD);
        map.put("SageMakerMachineLearningModelResourceData", SAGE_MAKER_MACHINE_LEARNING_MODEL_RESOURCE_DATA_FIELD);
        map.put("SecretsManagerSecretResourceData", SECRETS_MANAGER_SECRET_RESOURCE_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataContainer, T> g) {
        return obj -> g.apply((ResourceDataContainer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LocalDeviceResourceData localDeviceResourceData;
        private LocalVolumeResourceData localVolumeResourceData;
        private S3MachineLearningModelResourceData s3MachineLearningModelResourceData;
        private SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData;
        private SecretsManagerSecretResourceData secretsManagerSecretResourceData;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataContainer model) {
            this.localDeviceResourceData(model.localDeviceResourceData);
            this.localVolumeResourceData(model.localVolumeResourceData);
            this.s3MachineLearningModelResourceData(model.s3MachineLearningModelResourceData);
            this.sageMakerMachineLearningModelResourceData(model.sageMakerMachineLearningModelResourceData);
            this.secretsManagerSecretResourceData(model.secretsManagerSecretResourceData);
        }

        public final LocalDeviceResourceData.Builder getLocalDeviceResourceData() {
            return this.localDeviceResourceData != null ? this.localDeviceResourceData.toBuilder() : null;
        }

        public final void setLocalDeviceResourceData(LocalDeviceResourceData.BuilderImpl localDeviceResourceData) {
            this.localDeviceResourceData = localDeviceResourceData != null ? localDeviceResourceData.build() : null;
        }

        @Override
        public final Builder localDeviceResourceData(LocalDeviceResourceData localDeviceResourceData) {
            this.localDeviceResourceData = localDeviceResourceData;
            return this;
        }

        public final LocalVolumeResourceData.Builder getLocalVolumeResourceData() {
            return this.localVolumeResourceData != null ? this.localVolumeResourceData.toBuilder() : null;
        }

        public final void setLocalVolumeResourceData(LocalVolumeResourceData.BuilderImpl localVolumeResourceData) {
            this.localVolumeResourceData = localVolumeResourceData != null ? localVolumeResourceData.build() : null;
        }

        @Override
        public final Builder localVolumeResourceData(LocalVolumeResourceData localVolumeResourceData) {
            this.localVolumeResourceData = localVolumeResourceData;
            return this;
        }

        public final S3MachineLearningModelResourceData.Builder getS3MachineLearningModelResourceData() {
            return this.s3MachineLearningModelResourceData != null ? this.s3MachineLearningModelResourceData.toBuilder() : null;
        }

        public final void setS3MachineLearningModelResourceData(S3MachineLearningModelResourceData.BuilderImpl s3MachineLearningModelResourceData) {
            this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData != null ? s3MachineLearningModelResourceData.build() : null;
        }

        @Override
        public final Builder s3MachineLearningModelResourceData(S3MachineLearningModelResourceData s3MachineLearningModelResourceData) {
            this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
            return this;
        }

        public final SageMakerMachineLearningModelResourceData.Builder getSageMakerMachineLearningModelResourceData() {
            return this.sageMakerMachineLearningModelResourceData != null ? this.sageMakerMachineLearningModelResourceData.toBuilder() : null;
        }

        public final void setSageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData.BuilderImpl sageMakerMachineLearningModelResourceData) {
            this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData != null ? sageMakerMachineLearningModelResourceData.build() : null;
        }

        @Override
        public final Builder sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData) {
            this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
            return this;
        }

        public final SecretsManagerSecretResourceData.Builder getSecretsManagerSecretResourceData() {
            return this.secretsManagerSecretResourceData != null ? this.secretsManagerSecretResourceData.toBuilder() : null;
        }

        public final void setSecretsManagerSecretResourceData(SecretsManagerSecretResourceData.BuilderImpl secretsManagerSecretResourceData) {
            this.secretsManagerSecretResourceData = secretsManagerSecretResourceData != null ? secretsManagerSecretResourceData.build() : null;
        }

        @Override
        public final Builder secretsManagerSecretResourceData(SecretsManagerSecretResourceData secretsManagerSecretResourceData) {
            this.secretsManagerSecretResourceData = secretsManagerSecretResourceData;
            return this;
        }

        public ResourceDataContainer build() {
            return new ResourceDataContainer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDataContainer> {
        public Builder localDeviceResourceData(LocalDeviceResourceData var1);

        default public Builder localDeviceResourceData(Consumer<LocalDeviceResourceData.Builder> localDeviceResourceData) {
            return this.localDeviceResourceData((LocalDeviceResourceData)((LocalDeviceResourceData.Builder)LocalDeviceResourceData.builder().applyMutation(localDeviceResourceData)).build());
        }

        public Builder localVolumeResourceData(LocalVolumeResourceData var1);

        default public Builder localVolumeResourceData(Consumer<LocalVolumeResourceData.Builder> localVolumeResourceData) {
            return this.localVolumeResourceData((LocalVolumeResourceData)((LocalVolumeResourceData.Builder)LocalVolumeResourceData.builder().applyMutation(localVolumeResourceData)).build());
        }

        public Builder s3MachineLearningModelResourceData(S3MachineLearningModelResourceData var1);

        default public Builder s3MachineLearningModelResourceData(Consumer<S3MachineLearningModelResourceData.Builder> s3MachineLearningModelResourceData) {
            return this.s3MachineLearningModelResourceData((S3MachineLearningModelResourceData)((S3MachineLearningModelResourceData.Builder)S3MachineLearningModelResourceData.builder().applyMutation(s3MachineLearningModelResourceData)).build());
        }

        public Builder sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData var1);

        default public Builder sageMakerMachineLearningModelResourceData(Consumer<SageMakerMachineLearningModelResourceData.Builder> sageMakerMachineLearningModelResourceData) {
            return this.sageMakerMachineLearningModelResourceData((SageMakerMachineLearningModelResourceData)((SageMakerMachineLearningModelResourceData.Builder)SageMakerMachineLearningModelResourceData.builder().applyMutation(sageMakerMachineLearningModelResourceData)).build());
        }

        public Builder secretsManagerSecretResourceData(SecretsManagerSecretResourceData var1);

        default public Builder secretsManagerSecretResourceData(Consumer<SecretsManagerSecretResourceData.Builder> secretsManagerSecretResourceData) {
            return this.secretsManagerSecretResourceData((SecretsManagerSecretResourceData)((SecretsManagerSecretResourceData.Builder)SecretsManagerSecretResourceData.builder().applyMutation(secretsManagerSecretResourceData)).build());
        }
    }
}

