/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.DeploymentType;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.services.greengrass.model.ErrorDetailsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentStatusResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, GetDeploymentStatusResponse> {
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(GetDeploymentStatusResponse.getter(GetDeploymentStatusResponse::deploymentStatus)).setter(GetDeploymentStatusResponse.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(GetDeploymentStatusResponse.getter(GetDeploymentStatusResponse::deploymentTypeAsString)).setter(GetDeploymentStatusResponse.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetails").getter(GetDeploymentStatusResponse.getter(GetDeploymentStatusResponse::errorDetails)).setter(GetDeploymentStatusResponse.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetDeploymentStatusResponse.getter(GetDeploymentStatusResponse::errorMessage)).setter(GetDeploymentStatusResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedAt").getter(GetDeploymentStatusResponse.getter(GetDeploymentStatusResponse::updatedAt)).setter(GetDeploymentStatusResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_TYPE_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
            this.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
            this.put("ErrorDetails", ERROR_DETAILS_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
        }
    });
    private final String deploymentStatus;
    private final String deploymentType;
    private final List<ErrorDetail> errorDetails;
    private final String errorMessage;
    private final String updatedAt;

    private GetDeploymentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.updatedAt = builder.updatedAt;
    }

    public final String deploymentStatus() {
        return this.deploymentStatus;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentStatusResponse)) {
            return false;
        }
        GetDeploymentStatusResponse other = (GetDeploymentStatusResponse)((Object)obj);
        return Objects.equals(this.deploymentStatus(), other.deploymentStatus()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeploymentStatusResponse").add("DeploymentStatus", (Object)this.deploymentStatus()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).add("ErrorMessage", (Object)this.errorMessage()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentStatusResponse, T> g) {
        return obj -> g.apply((GetDeploymentStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String deploymentStatus;
        private String deploymentType;
        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;
        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentStatusResponse model) {
            super(model);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentType(model.deploymentType);
            this.errorDetails(model.errorDetails);
            this.errorMessage(model.errorMessage);
            this.updatedAt(model.updatedAt);
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetails() {
            List<ErrorDetail.Builder> result = ErrorDetailsCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDeploymentStatusResponse build() {
            return new GetDeploymentStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentStatusResponse> {
        public Builder deploymentStatus(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder errorDetails(Consumer<ErrorDetail.Builder> ... var1);

        public Builder errorMessage(String var1);

        public Builder updatedAt(String var1);
    }
}

