/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.ResourceDataContainer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Resource.getter(Resource::id)).setter(Resource.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Resource.getter(Resource::name)).setter(Resource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ResourceDataContainer> RESOURCE_DATA_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDataContainer").getter(Resource.getter(Resource::resourceDataContainer)).setter(Resource.setter(Builder::resourceDataContainer)).constructor(ResourceDataContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDataContainer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, RESOURCE_DATA_CONTAINER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ResourceDataContainer", RESOURCE_DATA_CONTAINER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final ResourceDataContainer resourceDataContainer;

    private Resource(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.resourceDataContainer = builder.resourceDataContainer;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceDataContainer resourceDataContainer() {
        return this.resourceDataContainer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDataContainer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceDataContainer(), other.resourceDataContainer());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ResourceDataContainer", (Object)this.resourceDataContainer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceDataContainer": {
                return Optional.ofNullable(clazz.cast(this.resourceDataContainer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private ResourceDataContainer resourceDataContainer;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.id(model.id);
            this.name(model.name);
            this.resourceDataContainer(model.resourceDataContainer);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ResourceDataContainer.Builder getResourceDataContainer() {
            return this.resourceDataContainer != null ? this.resourceDataContainer.toBuilder() : null;
        }

        public final void setResourceDataContainer(ResourceDataContainer.BuilderImpl resourceDataContainer) {
            this.resourceDataContainer = resourceDataContainer != null ? resourceDataContainer.build() : null;
        }

        @Override
        public final Builder resourceDataContainer(ResourceDataContainer resourceDataContainer) {
            this.resourceDataContainer = resourceDataContainer;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder resourceDataContainer(ResourceDataContainer var1);

        default public Builder resourceDataContainer(Consumer<ResourceDataContainer.Builder> resourceDataContainer) {
            return this.resourceDataContainer((ResourceDataContainer)((ResourceDataContainer.Builder)ResourceDataContainer.builder().applyMutation(resourceDataContainer)).build());
        }
    }
}

