/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.FunctionIsolationMode;
import software.amazon.awssdk.services.greengrass.model.FunctionRunAsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionDefaultExecutionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionDefaultExecutionConfig> {
    private static final SdkField<String> ISOLATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsolationMode").getter(FunctionDefaultExecutionConfig.getter(FunctionDefaultExecutionConfig::isolationModeAsString)).setter(FunctionDefaultExecutionConfig.setter(Builder::isolationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolationMode").build()}).build();
    private static final SdkField<FunctionRunAsConfig> RUN_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunAs").getter(FunctionDefaultExecutionConfig.getter(FunctionDefaultExecutionConfig::runAs)).setter(FunctionDefaultExecutionConfig.setter(Builder::runAs)).constructor(FunctionRunAsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISOLATION_MODE_FIELD, RUN_AS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IsolationMode", ISOLATION_MODE_FIELD);
            this.put("RunAs", RUN_AS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String isolationMode;
    private final FunctionRunAsConfig runAs;

    private FunctionDefaultExecutionConfig(BuilderImpl builder) {
        this.isolationMode = builder.isolationMode;
        this.runAs = builder.runAs;
    }

    public final FunctionIsolationMode isolationMode() {
        return FunctionIsolationMode.fromValue(this.isolationMode);
    }

    public final String isolationModeAsString() {
        return this.isolationMode;
    }

    public final FunctionRunAsConfig runAs() {
        return this.runAs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isolationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runAs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefaultExecutionConfig)) {
            return false;
        }
        FunctionDefaultExecutionConfig other = (FunctionDefaultExecutionConfig)obj;
        return Objects.equals(this.isolationModeAsString(), other.isolationModeAsString()) && Objects.equals(this.runAs(), other.runAs());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionDefaultExecutionConfig").add("IsolationMode", (Object)this.isolationModeAsString()).add("RunAs", (Object)this.runAs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsolationMode": {
                return Optional.ofNullable(clazz.cast(this.isolationModeAsString()));
            }
            case "RunAs": {
                return Optional.ofNullable(clazz.cast(this.runAs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FunctionDefaultExecutionConfig, T> g) {
        return obj -> g.apply((FunctionDefaultExecutionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String isolationMode;
        private FunctionRunAsConfig runAs;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefaultExecutionConfig model) {
            this.isolationMode(model.isolationMode);
            this.runAs(model.runAs);
        }

        public final String getIsolationMode() {
            return this.isolationMode;
        }

        public final void setIsolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
        }

        @Override
        public final Builder isolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
            return this;
        }

        @Override
        public final Builder isolationMode(FunctionIsolationMode isolationMode) {
            this.isolationMode(isolationMode == null ? null : isolationMode.toString());
            return this;
        }

        public final FunctionRunAsConfig.Builder getRunAs() {
            return this.runAs != null ? this.runAs.toBuilder() : null;
        }

        public final void setRunAs(FunctionRunAsConfig.BuilderImpl runAs) {
            this.runAs = runAs != null ? runAs.build() : null;
        }

        @Override
        public final Builder runAs(FunctionRunAsConfig runAs) {
            this.runAs = runAs;
            return this;
        }

        public FunctionDefaultExecutionConfig build() {
            return new FunctionDefaultExecutionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionDefaultExecutionConfig> {
        public Builder isolationMode(String var1);

        public Builder isolationMode(FunctionIsolationMode var1);

        public Builder runAs(FunctionRunAsConfig var1);

        default public Builder runAs(Consumer<FunctionRunAsConfig.Builder> runAs) {
            return this.runAs((FunctionRunAsConfig)((FunctionRunAsConfig.Builder)FunctionRunAsConfig.builder().applyMutation(runAs)).build());
        }
    }
}

