/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrass.model.FunctionExecutionConfig;
import software.amazon.awssdk.services.greengrass.model.ResourceAccessPolicy;
import software.amazon.awssdk.services.greengrass.model.___listOfResourceAccessPolicyCopier;
import software.amazon.awssdk.services.greengrass.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionConfigurationEnvironment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionConfigurationEnvironment> {
    private static final SdkField<Boolean> ACCESS_SYSFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccessSysfs").getter(FunctionConfigurationEnvironment.getter(FunctionConfigurationEnvironment::accessSysfs)).setter(FunctionConfigurationEnvironment.setter(Builder::accessSysfs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessSysfs").build()}).build();
    private static final SdkField<FunctionExecutionConfig> EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Execution").getter(FunctionConfigurationEnvironment.getter(FunctionConfigurationEnvironment::execution)).setter(FunctionConfigurationEnvironment.setter(Builder::execution)).constructor(FunctionExecutionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Execution").build()}).build();
    private static final SdkField<List<ResourceAccessPolicy>> RESOURCE_ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceAccessPolicies").getter(FunctionConfigurationEnvironment.getter(FunctionConfigurationEnvironment::resourceAccessPolicies)).setter(FunctionConfigurationEnvironment.setter(Builder::resourceAccessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceAccessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Variables").getter(FunctionConfigurationEnvironment.getter(FunctionConfigurationEnvironment::variables)).setter(FunctionConfigurationEnvironment.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_SYSFS_FIELD, EXECUTION_FIELD, RESOURCE_ACCESS_POLICIES_FIELD, VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccessSysfs", ACCESS_SYSFS_FIELD);
            this.put("Execution", EXECUTION_FIELD);
            this.put("ResourceAccessPolicies", RESOURCE_ACCESS_POLICIES_FIELD);
            this.put("Variables", VARIABLES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean accessSysfs;
    private final FunctionExecutionConfig execution;
    private final List<ResourceAccessPolicy> resourceAccessPolicies;
    private final Map<String, String> variables;

    private FunctionConfigurationEnvironment(BuilderImpl builder) {
        this.accessSysfs = builder.accessSysfs;
        this.execution = builder.execution;
        this.resourceAccessPolicies = builder.resourceAccessPolicies;
        this.variables = builder.variables;
    }

    public final Boolean accessSysfs() {
        return this.accessSysfs;
    }

    public final FunctionExecutionConfig execution() {
        return this.execution;
    }

    public final boolean hasResourceAccessPolicies() {
        return this.resourceAccessPolicies != null && !(this.resourceAccessPolicies instanceof SdkAutoConstructList);
    }

    public final List<ResourceAccessPolicy> resourceAccessPolicies() {
        return this.resourceAccessPolicies;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessSysfs());
        hashCode = 31 * hashCode + Objects.hashCode(this.execution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceAccessPolicies() ? this.resourceAccessPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfigurationEnvironment)) {
            return false;
        }
        FunctionConfigurationEnvironment other = (FunctionConfigurationEnvironment)obj;
        return Objects.equals(this.accessSysfs(), other.accessSysfs()) && Objects.equals(this.execution(), other.execution()) && this.hasResourceAccessPolicies() == other.hasResourceAccessPolicies() && Objects.equals(this.resourceAccessPolicies(), other.resourceAccessPolicies()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionConfigurationEnvironment").add("AccessSysfs", (Object)this.accessSysfs()).add("Execution", (Object)this.execution()).add("ResourceAccessPolicies", this.hasResourceAccessPolicies() ? this.resourceAccessPolicies() : null).add("Variables", this.hasVariables() ? this.variables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessSysfs": {
                return Optional.ofNullable(clazz.cast(this.accessSysfs()));
            }
            case "Execution": {
                return Optional.ofNullable(clazz.cast(this.execution()));
            }
            case "ResourceAccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessPolicies()));
            }
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfigurationEnvironment, T> g) {
        return obj -> g.apply((FunctionConfigurationEnvironment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean accessSysfs;
        private FunctionExecutionConfig execution;
        private List<ResourceAccessPolicy> resourceAccessPolicies = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfigurationEnvironment model) {
            this.accessSysfs(model.accessSysfs);
            this.execution(model.execution);
            this.resourceAccessPolicies(model.resourceAccessPolicies);
            this.variables(model.variables);
        }

        public final Boolean getAccessSysfs() {
            return this.accessSysfs;
        }

        public final void setAccessSysfs(Boolean accessSysfs) {
            this.accessSysfs = accessSysfs;
        }

        @Override
        public final Builder accessSysfs(Boolean accessSysfs) {
            this.accessSysfs = accessSysfs;
            return this;
        }

        public final FunctionExecutionConfig.Builder getExecution() {
            return this.execution != null ? this.execution.toBuilder() : null;
        }

        public final void setExecution(FunctionExecutionConfig.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(FunctionExecutionConfig execution) {
            this.execution = execution;
            return this;
        }

        public final List<ResourceAccessPolicy.Builder> getResourceAccessPolicies() {
            List<ResourceAccessPolicy.Builder> result = ___listOfResourceAccessPolicyCopier.copyToBuilder(this.resourceAccessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceAccessPolicies(Collection<ResourceAccessPolicy.BuilderImpl> resourceAccessPolicies) {
            this.resourceAccessPolicies = ___listOfResourceAccessPolicyCopier.copyFromBuilder(resourceAccessPolicies);
        }

        @Override
        public final Builder resourceAccessPolicies(Collection<ResourceAccessPolicy> resourceAccessPolicies) {
            this.resourceAccessPolicies = ___listOfResourceAccessPolicyCopier.copy(resourceAccessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAccessPolicies(ResourceAccessPolicy ... resourceAccessPolicies) {
            this.resourceAccessPolicies(Arrays.asList(resourceAccessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAccessPolicies(Consumer<ResourceAccessPolicy.Builder> ... resourceAccessPolicies) {
            this.resourceAccessPolicies(Stream.of(resourceAccessPolicies).map(c -> (ResourceAccessPolicy)((ResourceAccessPolicy.Builder)ResourceAccessPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = ___mapOf__stringCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = ___mapOf__stringCopier.copy(variables);
            return this;
        }

        public FunctionConfigurationEnvironment build() {
            return new FunctionConfigurationEnvironment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionConfigurationEnvironment> {
        public Builder accessSysfs(Boolean var1);

        public Builder execution(FunctionExecutionConfig var1);

        default public Builder execution(Consumer<FunctionExecutionConfig.Builder> execution) {
            return this.execution((FunctionExecutionConfig)((FunctionExecutionConfig.Builder)FunctionExecutionConfig.builder().applyMutation(execution)).build());
        }

        public Builder resourceAccessPolicies(Collection<ResourceAccessPolicy> var1);

        public Builder resourceAccessPolicies(ResourceAccessPolicy ... var1);

        public Builder resourceAccessPolicies(Consumer<ResourceAccessPolicy.Builder> ... var1);

        public Builder variables(Map<String, String> var1);
    }
}

