/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LoggerType {
    FILE_SYSTEM("FileSystem"),
    AWS_CLOUD_WATCH("AWSCloudWatch"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LoggerType> VALUE_MAP;
    private final String value;

    private LoggerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoggerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoggerType> knownValues() {
        EnumSet<LoggerType> knownValues = EnumSet.allOf(LoggerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LoggerType.class, LoggerType::toString);
    }
}

