/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassAsyncClient;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassBaseClientBuilder;
import software.amazon.awssdk.services.greengrass.GreengrassAsyncClient;
import software.amazon.awssdk.services.greengrass.GreengrassAsyncClientBuilder;
import software.amazon.awssdk.services.greengrass.GreengrassServiceClientConfiguration;
import software.amazon.awssdk.services.greengrass.endpoints.GreengrassEndpointProvider;

@SdkInternalApi
final class DefaultGreengrassAsyncClientBuilder
extends DefaultGreengrassBaseClientBuilder<GreengrassAsyncClientBuilder, GreengrassAsyncClient>
implements GreengrassAsyncClientBuilder {
    DefaultGreengrassAsyncClientBuilder() {
    }

    @Override
    public DefaultGreengrassAsyncClientBuilder endpointProvider(GreengrassEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GreengrassAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGreengrassAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        GreengrassServiceClientConfiguration serviceClientConfiguration = GreengrassServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultGreengrassAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

