/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassBaseClientBuilder;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassClient;
import software.amazon.awssdk.services.greengrass.GreengrassClient;
import software.amazon.awssdk.services.greengrass.GreengrassClientBuilder;
import software.amazon.awssdk.services.greengrass.GreengrassServiceClientConfiguration;
import software.amazon.awssdk.services.greengrass.endpoints.GreengrassEndpointProvider;

@SdkInternalApi
final class DefaultGreengrassClientBuilder
extends DefaultGreengrassBaseClientBuilder<GreengrassClientBuilder, GreengrassClient>
implements GreengrassClientBuilder {
    DefaultGreengrassClientBuilder() {
    }

    @Override
    public DefaultGreengrassClientBuilder endpointProvider(GreengrassEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GreengrassClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGreengrassClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        GreengrassServiceClientConfiguration serviceClientConfiguration = GreengrassServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultGreengrassClient(serviceClientConfiguration, clientConfiguration);
    }
}

