/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassAsyncClient;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassBaseClientBuilder;
import software.amazon.awssdk.services.greengrass.GreengrassAsyncClient;
import software.amazon.awssdk.services.greengrass.GreengrassAsyncClientBuilder;
import software.amazon.awssdk.services.greengrass.GreengrassServiceClientConfiguration;
import software.amazon.awssdk.services.greengrass.endpoints.GreengrassEndpointProvider;

@SdkInternalApi
final class DefaultGreengrassAsyncClientBuilder
extends DefaultGreengrassBaseClientBuilder<GreengrassAsyncClientBuilder, GreengrassAsyncClient>
implements GreengrassAsyncClientBuilder {
    DefaultGreengrassAsyncClientBuilder() {
    }

    @Override
    public DefaultGreengrassAsyncClientBuilder endpointProvider(GreengrassEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GreengrassAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGreengrassAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GreengrassServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGreengrassAsyncClient client = new DefaultGreengrassAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GreengrassServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GreengrassServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

