/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.BulkDeploymentResult;
import software.amazon.awssdk.services.greengrass.model.BulkDeploymentResultsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBulkDeploymentDetailedReportsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListBulkDeploymentDetailedReportsResponse> {
    private static final SdkField<List<BulkDeploymentResult>> DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Deployments").getter(ListBulkDeploymentDetailedReportsResponse.getter(ListBulkDeploymentDetailedReportsResponse::deployments)).setter(ListBulkDeploymentDetailedReportsResponse.setter(Builder::deployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BulkDeploymentResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBulkDeploymentDetailedReportsResponse.getter(ListBulkDeploymentDetailedReportsResponse::nextToken)).setter(ListBulkDeploymentDetailedReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BulkDeploymentResult> deployments;
    private final String nextToken;

    private ListBulkDeploymentDetailedReportsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeployments() {
        return this.deployments != null && !(this.deployments instanceof SdkAutoConstructList);
    }

    public final List<BulkDeploymentResult> deployments() {
        return this.deployments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeployments() ? this.deployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBulkDeploymentDetailedReportsResponse)) {
            return false;
        }
        ListBulkDeploymentDetailedReportsResponse other = (ListBulkDeploymentDetailedReportsResponse)((Object)obj);
        return this.hasDeployments() == other.hasDeployments() && Objects.equals(this.deployments(), other.deployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBulkDeploymentDetailedReportsResponse").add("Deployments", this.hasDeployments() ? this.deployments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deployments": {
                return Optional.ofNullable(clazz.cast(this.deployments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBulkDeploymentDetailedReportsResponse, T> g) {
        return obj -> g.apply((ListBulkDeploymentDetailedReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<BulkDeploymentResult> deployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBulkDeploymentDetailedReportsResponse model) {
            super(model);
            this.deployments(model.deployments);
            this.nextToken(model.nextToken);
        }

        public final List<BulkDeploymentResult.Builder> getDeployments() {
            List<BulkDeploymentResult.Builder> result = BulkDeploymentResultsCopier.copyToBuilder(this.deployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployments(Collection<BulkDeploymentResult.BuilderImpl> deployments) {
            this.deployments = BulkDeploymentResultsCopier.copyFromBuilder(deployments);
        }

        @Override
        public final Builder deployments(Collection<BulkDeploymentResult> deployments) {
            this.deployments = BulkDeploymentResultsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(BulkDeploymentResult ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<BulkDeploymentResult.Builder> ... deployments) {
            this.deployments(Stream.of(deployments).map(c -> (BulkDeploymentResult)((BulkDeploymentResult.Builder)BulkDeploymentResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBulkDeploymentDetailedReportsResponse build() {
            return new ListBulkDeploymentDetailedReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBulkDeploymentDetailedReportsResponse> {
        public Builder deployments(Collection<BulkDeploymentResult> var1);

        public Builder deployments(BulkDeploymentResult ... var1);

        public Builder deployments(Consumer<BulkDeploymentResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

