/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.Core;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.___listOfCoreCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCoreDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmznClientToken").getter(CreateCoreDefinitionVersionRequest.getter(CreateCoreDefinitionVersionRequest::amznClientToken)).setter(CreateCoreDefinitionVersionRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<String> CORE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreDefinitionId").getter(CreateCoreDefinitionVersionRequest.getter(CreateCoreDefinitionVersionRequest::coreDefinitionId)).setter(CreateCoreDefinitionVersionRequest.setter(Builder::coreDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CoreDefinitionId").build()}).build();
    private static final SdkField<List<Core>> CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cores").getter(CreateCoreDefinitionVersionRequest.getter(CreateCoreDefinitionVersionRequest::cores)).setter(CreateCoreDefinitionVersionRequest.setter(Builder::cores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Core::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, CORE_DEFINITION_ID_FIELD, CORES_FIELD));
    private final String amznClientToken;
    private final String coreDefinitionId;
    private final List<Core> cores;

    private CreateCoreDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.coreDefinitionId = builder.coreDefinitionId;
        this.cores = builder.cores;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String coreDefinitionId() {
        return this.coreDefinitionId;
    }

    public boolean hasCores() {
        return this.cores != null && !(this.cores instanceof SdkAutoConstructList);
    }

    public List<Core> cores() {
        return this.cores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cores());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoreDefinitionVersionRequest)) {
            return false;
        }
        CreateCoreDefinitionVersionRequest other = (CreateCoreDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.coreDefinitionId(), other.coreDefinitionId()) && Objects.equals(this.cores(), other.cores());
    }

    public String toString() {
        return ToString.builder((String)"CreateCoreDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("CoreDefinitionId", (Object)this.coreDefinitionId()).add("Cores", this.cores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "CoreDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.coreDefinitionId()));
            }
            case "Cores": {
                return Optional.ofNullable(clazz.cast(this.cores()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCoreDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateCoreDefinitionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String coreDefinitionId;
        private List<Core> cores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCoreDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.coreDefinitionId(model.coreDefinitionId);
            this.cores(model.cores);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getCoreDefinitionId() {
            return this.coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        public final Collection<Core.Builder> getCores() {
            return this.cores != null ? (Collection)this.cores.stream().map(Core::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ___listOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core ... cores) {
            this.cores(Arrays.asList(cores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Consumer<Core.Builder> ... cores) {
            this.cores(Stream.of(cores).map(c -> (Core)((Core.Builder)Core.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCores(Collection<Core.BuilderImpl> cores) {
            this.cores = ___listOfCoreCopier.copyFromBuilder(cores);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCoreDefinitionVersionRequest build() {
            return new CreateCoreDefinitionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder coreDefinitionId(String var1);

        public Builder cores(Collection<Core> var1);

        public Builder cores(Core ... var1);

        public Builder cores(Consumer<Core.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

