/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecretsManagerSecretResourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecretsManagerSecretResourceData> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(SecretsManagerSecretResourceData.getter(SecretsManagerSecretResourceData::arn)).setter(SecretsManagerSecretResourceData.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalStagingLabelsToDownload").getter(SecretsManagerSecretResourceData.getter(SecretsManagerSecretResourceData::additionalStagingLabelsToDownload)).setter(SecretsManagerSecretResourceData.setter(Builder::additionalStagingLabelsToDownload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalStagingLabelsToDownload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> additionalStagingLabelsToDownload;

    private SecretsManagerSecretResourceData(BuilderImpl builder) {
        this.arn = builder.arn;
        this.additionalStagingLabelsToDownload = builder.additionalStagingLabelsToDownload;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasAdditionalStagingLabelsToDownload() {
        return this.additionalStagingLabelsToDownload != null && !(this.additionalStagingLabelsToDownload instanceof SdkAutoConstructList);
    }

    public List<String> additionalStagingLabelsToDownload() {
        return this.additionalStagingLabelsToDownload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalStagingLabelsToDownload() ? this.additionalStagingLabelsToDownload() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretsManagerSecretResourceData)) {
            return false;
        }
        SecretsManagerSecretResourceData other = (SecretsManagerSecretResourceData)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAdditionalStagingLabelsToDownload() == other.hasAdditionalStagingLabelsToDownload() && Objects.equals(this.additionalStagingLabelsToDownload(), other.additionalStagingLabelsToDownload());
    }

    public String toString() {
        return ToString.builder((String)"SecretsManagerSecretResourceData").add("ARN", (Object)this.arn()).add("AdditionalStagingLabelsToDownload", this.hasAdditionalStagingLabelsToDownload() ? this.additionalStagingLabelsToDownload() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AdditionalStagingLabelsToDownload": {
                return Optional.ofNullable(clazz.cast(this.additionalStagingLabelsToDownload()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecretsManagerSecretResourceData, T> g) {
        return obj -> g.apply((SecretsManagerSecretResourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> additionalStagingLabelsToDownload = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecretsManagerSecretResourceData model) {
            this.arn(model.arn);
            this.additionalStagingLabelsToDownload(model.additionalStagingLabelsToDownload);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getAdditionalStagingLabelsToDownload() {
            if (this.additionalStagingLabelsToDownload instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalStagingLabelsToDownload;
        }

        @Override
        public final Builder additionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload = ___listOf__stringCopier.copy(additionalStagingLabelsToDownload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalStagingLabelsToDownload(String ... additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload(Arrays.asList(additionalStagingLabelsToDownload));
            return this;
        }

        public final void setAdditionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload = ___listOf__stringCopier.copy(additionalStagingLabelsToDownload);
        }

        public SecretsManagerSecretResourceData build() {
            return new SecretsManagerSecretResourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecretsManagerSecretResourceData> {
        public Builder arn(String var1);

        public Builder additionalStagingLabelsToDownload(Collection<String> var1);

        public Builder additionalStagingLabelsToDownload(String ... var1);
    }
}

