/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.BulkDeployment;
import software.amazon.awssdk.services.greengrass.model.BulkDeploymentsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBulkDeploymentsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListBulkDeploymentsResponse> {
    private static final SdkField<List<BulkDeployment>> BULK_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BulkDeployments").getter(ListBulkDeploymentsResponse.getter(ListBulkDeploymentsResponse::bulkDeployments)).setter(ListBulkDeploymentsResponse.setter(Builder::bulkDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BulkDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBulkDeploymentsResponse.getter(ListBulkDeploymentsResponse::nextToken)).setter(ListBulkDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BulkDeployment> bulkDeployments;
    private final String nextToken;

    private ListBulkDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.bulkDeployments = builder.bulkDeployments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBulkDeployments() {
        return this.bulkDeployments != null && !(this.bulkDeployments instanceof SdkAutoConstructList);
    }

    public List<BulkDeployment> bulkDeployments() {
        return this.bulkDeployments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBulkDeployments() ? this.bulkDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBulkDeploymentsResponse)) {
            return false;
        }
        ListBulkDeploymentsResponse other = (ListBulkDeploymentsResponse)((Object)obj);
        return this.hasBulkDeployments() == other.hasBulkDeployments() && Objects.equals(this.bulkDeployments(), other.bulkDeployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBulkDeploymentsResponse").add("BulkDeployments", this.hasBulkDeployments() ? this.bulkDeployments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BulkDeployments": {
                return Optional.ofNullable(clazz.cast(this.bulkDeployments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBulkDeploymentsResponse, T> g) {
        return obj -> g.apply((ListBulkDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<BulkDeployment> bulkDeployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBulkDeploymentsResponse model) {
            super(model);
            this.bulkDeployments(model.bulkDeployments);
            this.nextToken(model.nextToken);
        }

        public final Collection<BulkDeployment.Builder> getBulkDeployments() {
            if (this.bulkDeployments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bulkDeployments != null ? (Collection)this.bulkDeployments.stream().map(BulkDeployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bulkDeployments(Collection<BulkDeployment> bulkDeployments) {
            this.bulkDeployments = BulkDeploymentsCopier.copy(bulkDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkDeployments(BulkDeployment ... bulkDeployments) {
            this.bulkDeployments(Arrays.asList(bulkDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkDeployments(Consumer<BulkDeployment.Builder> ... bulkDeployments) {
            this.bulkDeployments(Stream.of(bulkDeployments).map(c -> (BulkDeployment)((BulkDeployment.Builder)BulkDeployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBulkDeployments(Collection<BulkDeployment.BuilderImpl> bulkDeployments) {
            this.bulkDeployments = BulkDeploymentsCopier.copyFromBuilder(bulkDeployments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBulkDeploymentsResponse build() {
            return new ListBulkDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBulkDeploymentsResponse> {
        public Builder bulkDeployments(Collection<BulkDeployment> var1);

        public Builder bulkDeployments(BulkDeployment ... var1);

        public Builder bulkDeployments(Consumer<BulkDeployment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

