/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.Connector;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.___listOfConnectorCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateConnectorDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConnectorDefinitionVersionRequest.getter(CreateConnectorDefinitionVersionRequest::amznClientToken)).setter(CreateConnectorDefinitionVersionRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<String> CONNECTOR_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConnectorDefinitionVersionRequest.getter(CreateConnectorDefinitionVersionRequest::connectorDefinitionId)).setter(CreateConnectorDefinitionVersionRequest.setter(Builder::connectorDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorDefinitionId").build()}).build();
    private static final SdkField<List<Connector>> CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateConnectorDefinitionVersionRequest.getter(CreateConnectorDefinitionVersionRequest::connectors)).setter(CreateConnectorDefinitionVersionRequest.setter(Builder::connectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Connector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, CONNECTOR_DEFINITION_ID_FIELD, CONNECTORS_FIELD));
    private final String amznClientToken;
    private final String connectorDefinitionId;
    private final List<Connector> connectors;

    private CreateConnectorDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.connectorDefinitionId = builder.connectorDefinitionId;
        this.connectors = builder.connectors;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String connectorDefinitionId() {
        return this.connectorDefinitionId;
    }

    public boolean hasConnectors() {
        return this.connectors != null && !(this.connectors instanceof SdkAutoConstructList);
    }

    public List<Connector> connectors() {
        return this.connectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorDefinitionVersionRequest)) {
            return false;
        }
        CreateConnectorDefinitionVersionRequest other = (CreateConnectorDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.connectorDefinitionId(), other.connectorDefinitionId()) && Objects.equals(this.connectors(), other.connectors());
    }

    public String toString() {
        return ToString.builder((String)"CreateConnectorDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("ConnectorDefinitionId", (Object)this.connectorDefinitionId()).add("Connectors", this.connectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "ConnectorDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.connectorDefinitionId()));
            }
            case "Connectors": {
                return Optional.ofNullable(clazz.cast(this.connectors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateConnectorDefinitionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String connectorDefinitionId;
        private List<Connector> connectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.connectorDefinitionId(model.connectorDefinitionId);
            this.connectors(model.connectors);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getConnectorDefinitionId() {
            return this.connectorDefinitionId;
        }

        @Override
        public final Builder connectorDefinitionId(String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
            return this;
        }

        public final void setConnectorDefinitionId(String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
        }

        public final Collection<Connector.Builder> getConnectors() {
            return this.connectors != null ? (Collection)this.connectors.stream().map(Connector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectors(Collection<Connector> connectors) {
            this.connectors = ___listOfConnectorCopier.copy(connectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Connector ... connectors) {
            this.connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Consumer<Connector.Builder> ... connectors) {
            this.connectors(Stream.of(connectors).map(c -> (Connector)((Connector.Builder)Connector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectors(Collection<Connector.BuilderImpl> connectors) {
            this.connectors = ___listOfConnectorCopier.copyFromBuilder(connectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorDefinitionVersionRequest build() {
            return new CreateConnectorDefinitionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder connectorDefinitionId(String var1);

        public Builder connectors(Collection<Connector> var1);

        public Builder connectors(Connector ... var1);

        public Builder connectors(Consumer<Connector.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

