/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectivityInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectivityInfo> {
    private static final SdkField<String> HOST_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectivityInfo.getter(ConnectivityInfo::hostAddress)).setter(ConnectivityInfo.setter(Builder::hostAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostAddress").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectivityInfo.getter(ConnectivityInfo::id)).setter(ConnectivityInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectivityInfo.getter(ConnectivityInfo::metadata)).setter(ConnectivityInfo.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<Integer> PORT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ConnectivityInfo.getter(ConnectivityInfo::portNumber)).setter(ConnectivityInfo.setter(Builder::portNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ADDRESS_FIELD, ID_FIELD, METADATA_FIELD, PORT_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostAddress;
    private final String id;
    private final String metadata;
    private final Integer portNumber;

    private ConnectivityInfo(BuilderImpl builder) {
        this.hostAddress = builder.hostAddress;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.portNumber = builder.portNumber;
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public String id() {
        return this.id;
    }

    public String metadata() {
        return this.metadata;
    }

    public Integer portNumber() {
        return this.portNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.portNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo)obj;
        return Objects.equals(this.hostAddress(), other.hostAddress()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.portNumber(), other.portNumber());
    }

    public String toString() {
        return ToString.builder((String)"ConnectivityInfo").add("HostAddress", (Object)this.hostAddress()).add("Id", (Object)this.id()).add("Metadata", (Object)this.metadata()).add("PortNumber", (Object)this.portNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostAddress": {
                return Optional.ofNullable(clazz.cast(this.hostAddress()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "PortNumber": {
                return Optional.ofNullable(clazz.cast(this.portNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectivityInfo, T> g) {
        return obj -> g.apply((ConnectivityInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostAddress;
        private String id;
        private String metadata;
        private Integer portNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            this.hostAddress(model.hostAddress);
            this.id(model.id);
            this.metadata(model.metadata);
            this.portNumber(model.portNumber);
        }

        public final String getHostAddress() {
            return this.hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Integer getPortNumber() {
            return this.portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectivityInfo> {
        public Builder hostAddress(String var1);

        public Builder id(String var1);

        public Builder metadata(String var1);

        public Builder portNumber(Integer var1);
    }
}

