/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateSubscriptionDefinitionVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> SUBSCRIPTIONDEFINITIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("SubscriptionDefinitionId").isBinary(false).build();
    private static final MarshallingInfo<List> SUBSCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subscriptions").isBinary(false).build();
    private static final CreateSubscriptionDefinitionVersionRequestModelMarshaller INSTANCE = new CreateSubscriptionDefinitionVersionRequestModelMarshaller();

    private CreateSubscriptionDefinitionVersionRequestModelMarshaller() {
    }

    public static CreateSubscriptionDefinitionVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateSubscriptionDefinitionVersionRequest createSubscriptionDefinitionVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createSubscriptionDefinitionVersionRequest), (String)"createSubscriptionDefinitionVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createSubscriptionDefinitionVersionRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createSubscriptionDefinitionVersionRequest.subscriptionDefinitionId(), SUBSCRIPTIONDEFINITIONID_BINDING);
            protocolMarshaller.marshall(createSubscriptionDefinitionVersionRequest.subscriptions(), SUBSCRIPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

