/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDeploymentRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentType").isBinary(false).build();
    private static final MarshallingInfo<String> GROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("GroupId").isBinary(false).build();
    private static final MarshallingInfo<String> GROUPVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupVersionId").isBinary(false).build();
    private static final CreateDeploymentRequestModelMarshaller INSTANCE = new CreateDeploymentRequestModelMarshaller();

    private CreateDeploymentRequestModelMarshaller() {
    }

    public static CreateDeploymentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDeploymentRequest createDeploymentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDeploymentRequest), (String)"createDeploymentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDeploymentRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.deploymentTypeString(), DEPLOYMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.groupId(), GROUPID_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.groupVersionId(), GROUPVERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

