/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetGroupVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, GetGroupVersionRequest> {
    private final String groupId;
    private final String groupVersionId;

    private GetGroupVersionRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.groupVersionId = builder.groupVersionId;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupVersionId() {
        return this.groupVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupVersionRequest)) {
            return false;
        }
        GetGroupVersionRequest other = (GetGroupVersionRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupVersionId(), other.groupVersionId());
    }

    public String toString() {
        return ToString.builder((String)"GetGroupVersionRequest").add("GroupId", (Object)this.groupId()).add("GroupVersionId", (Object)this.groupVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "GroupVersionId": {
                return Optional.of(clazz.cast(this.groupVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String groupId;
        private String groupVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupVersionRequest model) {
            this.groupId(model.groupId);
            this.groupVersionId(model.groupVersionId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupVersionId() {
            return this.groupVersionId;
        }

        @Override
        public final Builder groupVersionId(String groupVersionId) {
            this.groupVersionId = groupVersionId;
            return this;
        }

        public final void setGroupVersionId(String groupVersionId) {
            this.groupVersionId = groupVersionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetGroupVersionRequest build() {
            return new GetGroupVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, GetGroupVersionRequest> {
        public Builder groupId(String var1);

        public Builder groupVersionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

