/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDeploymentStatusRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, GetDeploymentStatusRequest> {
    private final String deploymentId;
    private final String groupId;

    private GetDeploymentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.groupId = builder.groupId;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String groupId() {
        return this.groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentStatusRequest)) {
            return false;
        }
        GetDeploymentStatusRequest other = (GetDeploymentStatusRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.groupId(), other.groupId());
    }

    public String toString() {
        return ToString.builder((String)"GetDeploymentStatusRequest").add("DeploymentId", (Object)this.deploymentId()).add("GroupId", (Object)this.groupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentStatusRequest model) {
            this.deploymentId(model.deploymentId);
            this.groupId(model.groupId);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDeploymentStatusRequest build() {
            return new GetDeploymentStatusRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, GetDeploymentStatusRequest> {
        public Builder deploymentId(String var1);

        public Builder groupId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

