/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.transform.ConnectivityInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConnectivityInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ConnectivityInfo> {
    private final String hostAddress;
    private final String id;
    private final String metadata;
    private final Integer portNumber;

    private ConnectivityInfo(BuilderImpl builder) {
        this.hostAddress = builder.hostAddress;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.portNumber = builder.portNumber;
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public String id() {
        return this.id;
    }

    public String metadata() {
        return this.metadata;
    }

    public Integer portNumber() {
        return this.portNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.portNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo)obj;
        return Objects.equals(this.hostAddress(), other.hostAddress()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.portNumber(), other.portNumber());
    }

    public String toString() {
        return ToString.builder((String)"ConnectivityInfo").add("HostAddress", (Object)this.hostAddress()).add("Id", (Object)this.id()).add("Metadata", (Object)this.metadata()).add("PortNumber", (Object)this.portNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostAddress": {
                return Optional.of(clazz.cast(this.hostAddress()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "PortNumber": {
                return Optional.of(clazz.cast(this.portNumber()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectivityInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostAddress;
        private String id;
        private String metadata;
        private Integer portNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            this.hostAddress(model.hostAddress);
            this.id(model.id);
            this.metadata(model.metadata);
            this.portNumber(model.portNumber);
        }

        public final String getHostAddress() {
            return this.hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Integer getPortNumber() {
            return this.portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConnectivityInfo> {
        public Builder hostAddress(String var1);

        public Builder id(String var1);

        public Builder metadata(String var1);

        public Builder portNumber(Integer var1);
    }
}

