/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateGroupCertificateConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateGroupCertificateConfigurationRequest> {
    private final String certificateExpiryInMilliseconds;
    private final String groupId;

    private UpdateGroupCertificateConfigurationRequest(BuilderImpl builder) {
        this.certificateExpiryInMilliseconds = builder.certificateExpiryInMilliseconds;
        this.groupId = builder.groupId;
    }

    public String certificateExpiryInMilliseconds() {
        return this.certificateExpiryInMilliseconds;
    }

    public String groupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateExpiryInMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupCertificateConfigurationRequest)) {
            return false;
        }
        UpdateGroupCertificateConfigurationRequest other = (UpdateGroupCertificateConfigurationRequest)((Object)obj);
        return Objects.equals(this.certificateExpiryInMilliseconds(), other.certificateExpiryInMilliseconds()) && Objects.equals(this.groupId(), other.groupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificateExpiryInMilliseconds() != null) {
            sb.append("CertificateExpiryInMilliseconds: ").append(this.certificateExpiryInMilliseconds()).append(",");
        }
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateExpiryInMilliseconds": {
                return Optional.of(clazz.cast(this.certificateExpiryInMilliseconds()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateExpiryInMilliseconds;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupCertificateConfigurationRequest model) {
            this.certificateExpiryInMilliseconds(model.certificateExpiryInMilliseconds);
            this.groupId(model.groupId);
        }

        public final String getCertificateExpiryInMilliseconds() {
            return this.certificateExpiryInMilliseconds;
        }

        @Override
        public final Builder certificateExpiryInMilliseconds(String certificateExpiryInMilliseconds) {
            this.certificateExpiryInMilliseconds = certificateExpiryInMilliseconds;
            return this;
        }

        public final void setCertificateExpiryInMilliseconds(String certificateExpiryInMilliseconds) {
            this.certificateExpiryInMilliseconds = certificateExpiryInMilliseconds;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public UpdateGroupCertificateConfigurationRequest build() {
            return new UpdateGroupCertificateConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateGroupCertificateConfigurationRequest> {
        public Builder certificateExpiryInMilliseconds(String var1);

        public Builder groupId(String var1);
    }
}

