/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Function;

@SdkInternalApi
public class FunctionMarshaller {
    private static final MarshallingInfo<String> FUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionArn").build();
    private static final MarshallingInfo<StructuredPojo> FUNCTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionConfiguration").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final FunctionMarshaller instance = new FunctionMarshaller();

    public static FunctionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Function function, ProtocolMarshaller protocolMarshaller) {
        if (function == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)function.functionArn(), FUNCTIONARN_BINDING);
            protocolMarshaller.marshall((Object)function.functionConfiguration(), FUNCTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)function.id(), ID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

