/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.greengrass.model.GroupInformation;
import software.amazon.awssdk.services.greengrass.model.ListOfGroupInformationCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListGroupsResponse> {
    private final List<GroupInformation> groups;
    private final String nextToken;

    private ListGroupsResponse(BuilderImpl builder) {
        this.groups = builder.groups;
        this.nextToken = builder.nextToken;
    }

    public List<GroupInformation> groups() {
        return this.groups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResponse)) {
            return false;
        }
        ListGroupsResponse other = (ListGroupsResponse)((Object)obj);
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GroupInformation> groups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsResponse model) {
            this.setGroups(model.groups);
            this.setNextToken(model.nextToken);
        }

        public final Collection<GroupInformation> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<GroupInformation> groups) {
            this.groups = ListOfGroupInformationCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupInformation ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupInformation> groups) {
            this.groups = ListOfGroupInformationCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupInformation ... groups) {
            this.groups(Arrays.asList(groups));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListGroupsResponse build() {
            return new ListGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListGroupsResponse> {
        public Builder groups(Collection<GroupInformation> var1);

        public Builder groups(GroupInformation ... var1);

        public Builder nextToken(String var1);
    }
}

