/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Device;
import software.amazon.awssdk.services.greengrass.model.ListOfDeviceCopier;
import software.amazon.awssdk.services.greengrass.transform.DeviceDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeviceDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceDefinitionVersion> {
    private final List<Device> devices;

    private DeviceDefinitionVersion(BuilderImpl builder) {
        this.devices = builder.devices;
    }

    public List<Device> devices() {
        return this.devices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.devices() == null ? 0 : this.devices().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDefinitionVersion)) {
            return false;
        }
        DeviceDefinitionVersion other = (DeviceDefinitionVersion)obj;
        if (other.devices() == null ^ this.devices() == null) {
            return false;
        }
        return other.devices() == null || other.devices().equals(this.devices());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devices() != null) {
            sb.append("Devices: ").append(this.devices()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Device> devices;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDefinitionVersion model) {
            this.setDevices(model.devices);
        }

        public final Collection<Device> getDevices() {
            return this.devices;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = ListOfDeviceCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        public final void setDevices(Collection<Device> devices) {
            this.devices = ListOfDeviceCopier.copy(devices);
        }

        @SafeVarargs
        public final void setDevices(Device ... devices) {
            this.devices(Arrays.asList(devices));
        }

        public DeviceDefinitionVersion build() {
            return new DeviceDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceDefinitionVersion> {
        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);
    }
}

