/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Core;
import software.amazon.awssdk.services.greengrass.model.ListOfCoreCopier;
import software.amazon.awssdk.services.greengrass.transform.CoreDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CoreDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, CoreDefinitionVersion> {
    private final List<Core> cores;

    private CoreDefinitionVersion(BuilderImpl builder) {
        this.cores = builder.cores;
    }

    public List<Core> cores() {
        return this.cores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cores() == null ? 0 : this.cores().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreDefinitionVersion)) {
            return false;
        }
        CoreDefinitionVersion other = (CoreDefinitionVersion)obj;
        if (other.cores() == null ^ this.cores() == null) {
            return false;
        }
        return other.cores() == null || other.cores().equals(this.cores());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cores() != null) {
            sb.append("Cores: ").append(this.cores()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CoreDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Core> cores;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreDefinitionVersion model) {
            this.setCores(model.cores);
        }

        public final Collection<Core> getCores() {
            return this.cores;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ListOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core ... cores) {
            this.cores(Arrays.asList(cores));
            return this;
        }

        public final void setCores(Collection<Core> cores) {
            this.cores = ListOfCoreCopier.copy(cores);
        }

        @SafeVarargs
        public final void setCores(Core ... cores) {
            this.cores(Arrays.asList(cores));
        }

        public CoreDefinitionVersion build() {
            return new CoreDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CoreDefinitionVersion> {
        public Builder cores(Collection<Core> var1);

        public Builder cores(Core ... var1);
    }
}

