/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.Subscription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscriptionMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").isBinary(false).build();
    private static final MarshallingInfo<String> TARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Target").isBinary(false).build();
    private static final SubscriptionMarshaller INSTANCE = new SubscriptionMarshaller();

    private SubscriptionMarshaller() {
    }

    public static SubscriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subscription subscription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subscription, (String)"subscription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subscription.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)subscription.source(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)subscription.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)subscription.target(), TARGET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

