/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.Deployment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentMarshaller {
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentType").isBinary(false).build();
    private static final MarshallingInfo<String> GROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupArn").isBinary(false).build();
    private static final DeploymentMarshaller INSTANCE = new DeploymentMarshaller();

    private DeploymentMarshaller() {
    }

    public static DeploymentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Deployment deployment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deployment, (String)"deployment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deployment.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)deployment.deploymentArn(), DEPLOYMENTARN_BINDING);
            protocolMarshaller.marshall((Object)deployment.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)deployment.deploymentTypeAsString(), DEPLOYMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)deployment.groupArn(), GROUPARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

