/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.ListOfSubscriptionCopier;
import software.amazon.awssdk.services.greengrass.model.Subscription;
import software.amazon.awssdk.services.greengrass.transform.SubscriptionDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubscriptionDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, SubscriptionDefinitionVersion> {
    private final List<Subscription> subscriptions;

    private SubscriptionDefinitionVersion(BuilderImpl builder) {
        this.subscriptions = builder.subscriptions;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionDefinitionVersion)) {
            return false;
        }
        SubscriptionDefinitionVersion other = (SubscriptionDefinitionVersion)obj;
        return Objects.equals(this.subscriptions(), other.subscriptions());
    }

    public String toString() {
        return ToString.builder((String)"SubscriptionDefinitionVersion").add("Subscriptions", this.subscriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subscriptions": {
                return Optional.of(clazz.cast(this.subscriptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionDefinitionVersion model) {
            this.subscriptions(model.subscriptions);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return this.subscriptions != null ? (Collection)this.subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copyFromBuilder(subscriptions);
        }

        public SubscriptionDefinitionVersion build() {
            return new SubscriptionDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubscriptionDefinitionVersion> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);
    }
}

