/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeviceDefinitionVersionsRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, ListDeviceDefinitionVersionsRequest> {
    private final String deviceDefinitionId;
    private final String maxResults;
    private final String nextToken;

    private ListDeviceDefinitionVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.deviceDefinitionId = builder.deviceDefinitionId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String deviceDefinitionId() {
        return this.deviceDefinitionId;
    }

    public String maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceDefinitionVersionsRequest)) {
            return false;
        }
        ListDeviceDefinitionVersionsRequest other = (ListDeviceDefinitionVersionsRequest)((Object)obj);
        return Objects.equals(this.deviceDefinitionId(), other.deviceDefinitionId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeviceDefinitionVersionsRequest").add("DeviceDefinitionId", (Object)this.deviceDefinitionId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceDefinitionId": {
                return Optional.of(clazz.cast(this.deviceDefinitionId()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String deviceDefinitionId;
        private String maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceDefinitionVersionsRequest model) {
            super(model);
            this.deviceDefinitionId(model.deviceDefinitionId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getDeviceDefinitionId() {
            return this.deviceDefinitionId;
        }

        @Override
        public final Builder deviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        public final void setDeviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
        }

        public final String getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceDefinitionVersionsRequest build() {
            return new ListDeviceDefinitionVersionsRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, ListDeviceDefinitionVersionsRequest> {
        public Builder deviceDefinitionId(String var1);

        public Builder maxResults(String var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

