/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.DeviceDefinitionVersion;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeviceDefinitionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateDeviceDefinitionRequest> {
    private final String amznClientToken;
    private final DeviceDefinitionVersion initialVersion;
    private final String name;

    private CreateDeviceDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.initialVersion = builder.initialVersion;
        this.name = builder.name;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public DeviceDefinitionVersion initialVersion() {
        return this.initialVersion;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceDefinitionRequest)) {
            return false;
        }
        CreateDeviceDefinitionRequest other = (CreateDeviceDefinitionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.initialVersion(), other.initialVersion()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeviceDefinitionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("InitialVersion", (Object)this.initialVersion()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "InitialVersion": {
                return Optional.of(clazz.cast(this.initialVersion()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private DeviceDefinitionVersion initialVersion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceDefinitionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.initialVersion(model.initialVersion);
            this.name(model.name);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final DeviceDefinitionVersion.Builder getInitialVersion() {
            return this.initialVersion != null ? this.initialVersion.toBuilder() : null;
        }

        @Override
        public final Builder initialVersion(DeviceDefinitionVersion initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        public final void setInitialVersion(DeviceDefinitionVersion.BuilderImpl initialVersion) {
            this.initialVersion = initialVersion != null ? initialVersion.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDeviceDefinitionRequest build() {
            return new CreateDeviceDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateDeviceDefinitionRequest> {
        public Builder amznClientToken(String var1);

        public Builder initialVersion(DeviceDefinitionVersion var1);

        default public Builder initialVersion(Consumer<DeviceDefinitionVersion.Builder> initialVersion) {
            return this.initialVersion((DeviceDefinitionVersion)((DeviceDefinitionVersion.Builder)DeviceDefinitionVersion.builder().apply(initialVersion)).build());
        }

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

