/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.FunctionConfiguration;

@SdkInternalApi
public class FunctionConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").build();
    private static final MarshallingInfo<String> EXECARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecArgs").build();
    private static final MarshallingInfo<String> EXECUTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Executable").build();
    private static final MarshallingInfo<Integer> MEMORYSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemorySize").build();
    private static final MarshallingInfo<Boolean> PINNED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pinned").build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").build();
    private static final FunctionConfigurationMarshaller instance = new FunctionConfigurationMarshaller();

    public static FunctionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(FunctionConfiguration functionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (functionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)functionConfiguration.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.execArgs(), EXECARGS_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.executable(), EXECUTABLE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.memorySize(), MEMORYSIZE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.pinned(), PINNED_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.timeout(), TIMEOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

