/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Function;
import software.amazon.awssdk.services.greengrass.model.ListOfFunctionCopier;
import software.amazon.awssdk.services.greengrass.transform.FunctionDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FunctionDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionDefinitionVersion> {
    private final List<Function> functions;

    private FunctionDefinitionVersion(BuilderImpl builder) {
        this.functions = builder.functions;
    }

    public List<Function> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functions() == null ? 0 : this.functions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefinitionVersion)) {
            return false;
        }
        FunctionDefinitionVersion other = (FunctionDefinitionVersion)obj;
        if (other.functions() == null ^ this.functions() == null) {
            return false;
        }
        return other.functions() == null || other.functions().equals(this.functions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.functions() != null) {
            sb.append("Functions: ").append(this.functions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Function> functions;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefinitionVersion model) {
            this.setFunctions(model.functions);
        }

        public final Collection<Function> getFunctions() {
            return this.functions;
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ListOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<Function>(functions.length);
            }
            for (Function e : functions) {
                this.functions.add(e);
            }
            return this;
        }

        public final void setFunctions(Collection<Function> functions) {
            this.functions = ListOfFunctionCopier.copy(functions);
        }

        @SafeVarargs
        public final void setFunctions(Function ... functions) {
            if (this.functions == null) {
                this.functions = new ArrayList<Function>(functions.length);
            }
            for (Function e : functions) {
                this.functions.add(e);
            }
        }

        public FunctionDefinitionVersion build() {
            return new FunctionDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionDefinitionVersion> {
        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);
    }
}

