/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfLoggerCopier;
import software.amazon.awssdk.services.greengrass.model.Logger;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoggerDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLoggerDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String loggerDefinitionId;
    private final List<Logger> loggers;

    private CreateLoggerDefinitionVersionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.loggerDefinitionId = builder.loggerDefinitionId;
        this.loggers = builder.loggers;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String loggerDefinitionId() {
        return this.loggerDefinitionId;
    }

    public List<Logger> loggers() {
        return this.loggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amznClientToken() == null ? 0 : this.amznClientToken().hashCode());
        hashCode = 31 * hashCode + (this.loggerDefinitionId() == null ? 0 : this.loggerDefinitionId().hashCode());
        hashCode = 31 * hashCode + (this.loggers() == null ? 0 : this.loggers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoggerDefinitionVersionRequest)) {
            return false;
        }
        CreateLoggerDefinitionVersionRequest other = (CreateLoggerDefinitionVersionRequest)((Object)obj);
        if (other.amznClientToken() == null ^ this.amznClientToken() == null) {
            return false;
        }
        if (other.amznClientToken() != null && !other.amznClientToken().equals(this.amznClientToken())) {
            return false;
        }
        if (other.loggerDefinitionId() == null ^ this.loggerDefinitionId() == null) {
            return false;
        }
        if (other.loggerDefinitionId() != null && !other.loggerDefinitionId().equals(this.loggerDefinitionId())) {
            return false;
        }
        if (other.loggers() == null ^ this.loggers() == null) {
            return false;
        }
        return other.loggers() == null || other.loggers().equals(this.loggers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.loggerDefinitionId() != null) {
            sb.append("LoggerDefinitionId: ").append(this.loggerDefinitionId()).append(",");
        }
        if (this.loggers() != null) {
            sb.append("Loggers: ").append(this.loggers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String loggerDefinitionId;
        private List<Logger> loggers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoggerDefinitionVersionRequest model) {
            this.setAmznClientToken(model.amznClientToken);
            this.setLoggerDefinitionId(model.loggerDefinitionId);
            this.setLoggers(model.loggers);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getLoggerDefinitionId() {
            return this.loggerDefinitionId;
        }

        @Override
        public final Builder loggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
            return this;
        }

        public final void setLoggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
        }

        public final Collection<Logger> getLoggers() {
            return this.loggers;
        }

        @Override
        public final Builder loggers(Collection<Logger> loggers) {
            this.loggers = ListOfLoggerCopier.copy(loggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Logger ... loggers) {
            if (this.loggers == null) {
                this.loggers = new ArrayList<Logger>(loggers.length);
            }
            for (Logger e : loggers) {
                this.loggers.add(e);
            }
            return this;
        }

        public final void setLoggers(Collection<Logger> loggers) {
            this.loggers = ListOfLoggerCopier.copy(loggers);
        }

        @SafeVarargs
        public final void setLoggers(Logger ... loggers) {
            if (this.loggers == null) {
                this.loggers = new ArrayList<Logger>(loggers.length);
            }
            for (Logger e : loggers) {
                this.loggers.add(e);
            }
        }

        public CreateLoggerDefinitionVersionRequest build() {
            return new CreateLoggerDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLoggerDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder loggerDefinitionId(String var1);

        public Builder loggers(Collection<Logger> var1);

        public Builder loggers(Logger ... var1);
    }
}

