/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountTokenListCopier;
import software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspaceServiceAccountTokensResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, ListWorkspaceServiceAccountTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkspaceServiceAccountTokensResponse.getter(ListWorkspaceServiceAccountTokensResponse::nextToken)).setter(ListWorkspaceServiceAccountTokensResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountId").getter(ListWorkspaceServiceAccountTokensResponse.getter(ListWorkspaceServiceAccountTokensResponse::serviceAccountId)).setter(ListWorkspaceServiceAccountTokensResponse.setter(Builder::serviceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountId").build()}).build();
    private static final SdkField<List<ServiceAccountTokenSummary>> SERVICE_ACCOUNT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceAccountTokens").getter(ListWorkspaceServiceAccountTokensResponse.getter(ListWorkspaceServiceAccountTokensResponse::serviceAccountTokens)).setter(ListWorkspaceServiceAccountTokensResponse.setter(Builder::serviceAccountTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceAccountTokenSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(ListWorkspaceServiceAccountTokensResponse.getter(ListWorkspaceServiceAccountTokensResponse::workspaceId)).setter(ListWorkspaceServiceAccountTokensResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_ACCOUNT_ID_FIELD, SERVICE_ACCOUNT_TOKENS_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkspaceServiceAccountTokensResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final String serviceAccountId;
    private final List<ServiceAccountTokenSummary> serviceAccountTokens;
    private final String workspaceId;

    private ListWorkspaceServiceAccountTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceAccountId = builder.serviceAccountId;
        this.serviceAccountTokens = builder.serviceAccountTokens;
        this.workspaceId = builder.workspaceId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String serviceAccountId() {
        return this.serviceAccountId;
    }

    public final boolean hasServiceAccountTokens() {
        return this.serviceAccountTokens != null && !(this.serviceAccountTokens instanceof SdkAutoConstructList);
    }

    public final List<ServiceAccountTokenSummary> serviceAccountTokens() {
        return this.serviceAccountTokens;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceAccountTokens() ? this.serviceAccountTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceServiceAccountTokensResponse)) {
            return false;
        }
        ListWorkspaceServiceAccountTokensResponse other = (ListWorkspaceServiceAccountTokensResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.serviceAccountId(), other.serviceAccountId()) && this.hasServiceAccountTokens() == other.hasServiceAccountTokens() && Objects.equals(this.serviceAccountTokens(), other.serviceAccountTokens()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspaceServiceAccountTokensResponse").add("NextToken", (Object)this.nextToken()).add("ServiceAccountId", (Object)this.serviceAccountId()).add("ServiceAccountTokens", this.hasServiceAccountTokens() ? this.serviceAccountTokens() : null).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "serviceAccountId": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountId()));
            }
            case "serviceAccountTokens": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountTokens()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serviceAccountId", SERVICE_ACCOUNT_ID_FIELD);
        map.put("serviceAccountTokens", SERVICE_ACCOUNT_TOKENS_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceServiceAccountTokensResponse, T> g) {
        return obj -> g.apply((ListWorkspaceServiceAccountTokensResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String serviceAccountId;
        private List<ServiceAccountTokenSummary> serviceAccountTokens = DefaultSdkAutoConstructList.getInstance();
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceServiceAccountTokensResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serviceAccountId(model.serviceAccountId);
            this.serviceAccountTokens(model.serviceAccountTokens);
            this.workspaceId(model.workspaceId);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final List<ServiceAccountTokenSummary.Builder> getServiceAccountTokens() {
            List<ServiceAccountTokenSummary.Builder> result = ServiceAccountTokenListCopier.copyToBuilder(this.serviceAccountTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceAccountTokens(Collection<ServiceAccountTokenSummary.BuilderImpl> serviceAccountTokens) {
            this.serviceAccountTokens = ServiceAccountTokenListCopier.copyFromBuilder(serviceAccountTokens);
        }

        @Override
        public final Builder serviceAccountTokens(Collection<ServiceAccountTokenSummary> serviceAccountTokens) {
            this.serviceAccountTokens = ServiceAccountTokenListCopier.copy(serviceAccountTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccountTokens(ServiceAccountTokenSummary ... serviceAccountTokens) {
            this.serviceAccountTokens(Arrays.asList(serviceAccountTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccountTokens(Consumer<ServiceAccountTokenSummary.Builder> ... serviceAccountTokens) {
            this.serviceAccountTokens(Stream.of(serviceAccountTokens).map(c -> (ServiceAccountTokenSummary)((ServiceAccountTokenSummary.Builder)ServiceAccountTokenSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public ListWorkspaceServiceAccountTokensResponse build() {
            return new ListWorkspaceServiceAccountTokensResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspaceServiceAccountTokensResponse> {
        public Builder nextToken(String var1);

        public Builder serviceAccountId(String var1);

        public Builder serviceAccountTokens(Collection<ServiceAccountTokenSummary> var1);

        public Builder serviceAccountTokens(ServiceAccountTokenSummary ... var1);

        public Builder serviceAccountTokens(Consumer<ServiceAccountTokenSummary.Builder> ... var1);

        public Builder workspaceId(String var1);
    }
}

